<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

// Fetch all attendance
$stmt = $pdo->prepare("SELECT * FROM attendance WHERE officer_id = ? ORDER BY date DESC");
$stmt->execute([$officer_id]);
$records = $stmt->fetchAll();

// Get attendance count this month
$monthCount = $pdo->prepare("SELECT COUNT(*) FROM attendance WHERE officer_id = ? AND MONTH(date) = MONTH(CURDATE()) AND YEAR(date) = YEAR(CURDATE())");
$monthCount->execute([$officer_id]);
$presentDays = $monthCount->fetchColumn();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Attendance Summary</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
  <style>
    body {
      background-color: #f5f9fc;
      font-family: 'Segoe UI', sans-serif;
      font-size: small;
    }
    .container {
      max-width: 1000px;
    }
  </style>
</head>
<body>

<div class="container">
  <div class="wrapper">
    <div class="row">
      <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="text-primary">🕒 My Attendance Summary</h4>
        <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
      </div>

      <div class="alert alert-info">✅ Present this month: <strong><?= $presentDays ?></strong> day(s)</div>

        <div class="table-responsive">
          <table id="attendanceTable" class="table table-bordered table-striped small">
            <thead class="table-dark">
              <tr>
                <th>#</th>
                <th>Date</th>
                <th>Time In</th>
                <th>Time Out</th>
                <th>Shift</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($records as $i => $r): ?>
              <tr>
                <td><?= $i + 1 ?></td>
                <td><?= $r['date'] ?></td>
                <td><?= $r['time_in'] ?? '<span class="text-muted">–</span>' ?></td>
                <td><?= $r['time_out'] ?? '<span class="text-muted">–</span>' ?></td>
                <td>
                  <?php
                    $hour = $r['time_in'] ? date('H', strtotime($r['time_in'])) : null;
                    echo $hour === null ? '<span class="text-muted">–</span>' : ($hour < 20 ? 'A (Day)' : 'B (Night)');
                  ?>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
    </div>
  </div>
</div>
<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $(document).ready(function () {
    $('#attendanceTable').DataTable({
      dom: 'Bfrtip',
      buttons: ['excelHtml5', 'print'],
      order: [[1, 'desc']]
    });
  });
</script>

</body>
</html>
