<?php
$current = basename($_SERVER['PHP_SELF']);
$occurrencePages = ['occurrence.php', 'view_occurrences.php', 'edit_occurrence.php', 'delete_occurrence.php', 'print_occurrence.php'];
?>

<aside class="main-sidebar sidebar-dark-primary elevation-4">
  <!-- Brand Logo -->
  <a href="dashboard.php" class="brand-link">
    <img src="../assets/images/app_logo.png" alt="CFS Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
    <span class="brand-text font-weight-light">OPS System</span>
  </a>

  <div class="sidebar">
    <!-- User Info -->
    <div class="user-panel mt-3 pb-3 mb-3 d-flex">
      <div class="image">
        <img src="../assets/images/avatar.png" class="img-circle elevation-2" alt="User Image">
      </div>
      <div class="info">
        <a href="dashboard.php" class="d-block"><?= htmlspecialchars($_SESSION['username'] ?? 'Controller') ?></a>
      </div>
    </div>

    <!-- Sidebar Menu -->
    <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

        <li class="nav-item">
          <a href="dashboard.php" class="nav-link <?= ($current == 'dashboard.php') ? 'active' : '' ?>">
            <i class="nav-icon fas fa-tachometer-alt"></i>
            <p>Dashboard</p>
          </a>
        </li>

        <li class="nav-item">
          <a href="view_today_attendance.php" class="nav-link <?= ($current == 'view_today_attendance.php') ? 'active' : '' ?>">
            <i class="nav-icon fas fa-users"></i>
            <p>Today's Attendance</p>
          </a>
        </li>

        <li class="nav-item">
          <a href="view_roster.php" class="nav-link <?= ($current == 'view_roster.php') ? 'active' : '' ?>">
            <i class="nav-icon fas fa-calendar-alt"></i>
            <p>Officer Roster</p>
          </a>
        </li>

        <!-- Occurrence Dropdown -->
        <li class="nav-item <?= in_array($current, $occurrencePages) ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= in_array($current, $occurrencePages) ? 'active' : '' ?>">
            <i class="nav-icon fas fa-clipboard-list"></i>
            <p>
              Occurrence Logs
              <i class="right fas fa-angle-left"></i>
            </p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="occurrence.php" class="nav-link <?= ($current == 'occurrence.php') ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Record Occurrence</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="view_occurrences.php" class="nav-link <?= ($current == 'view_occurrences.php') ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>View Occurrences</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="edit_occurrence.php" class="nav-link <?= ($current == 'edit_occurrence.php') ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Edit Occurrence</p>
              </a>
            </li>
          </ul>
        </li>

        <li class="nav-item">
          <a href="../auth/logout.php" class="nav-link">
            <i class="nav-icon fas fa-sign-out-alt text-danger"></i>
            <p>Logout</p>
          </a>
        </li>

      </ul>
    </nav>
  </div>
</aside>
