<?php
session_start();
require_once '../includes/config.php';

$controller_id = $_SESSION['user_id'] ?? null;
$success = $error = '';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'controller') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch sites
$sites = $pdo->query("SELECT id, site_name FROM sites ORDER BY site_name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $title = trim($_POST['title']);
  $description = trim($_POST['description']);
  $site_id = (int)$_POST['site_id'];

  $photo_path = '';
  $video_path = '';
  $upload_dir = '../uploads/incidents/';

  if (!is_dir($upload_dir)) mkdir($upload_dir, 0775, true);

  // Handle photo upload
  if (!empty($_FILES['photo']['name'])) {
    $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
    if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) {
      $photo_path = 'incidents/' . time() . '_' . basename($_FILES['photo']['name']);
      move_uploaded_file($_FILES['photo']['tmp_name'], $upload_dir . basename($photo_path));
    }
  }

  // Handle video upload
  if (!empty($_FILES['video']['name'])) {
    $ext = strtolower(pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION));
    if (in_array($ext, ['mp4', 'mov', 'avi'])) {
      $video_path = 'incidents/' . time() . '_' . basename($_FILES['video']['name']);
      move_uploaded_file($_FILES['video']['tmp_name'], $upload_dir . basename($video_path));
    }
  }

  // Save incident
  $stmt = $pdo->prepare("INSERT INTO incident_reports (officer_id, site_id, title, description, photo, video, submitted_by_role) VALUES (?, ?, ?, ?, ?, ?, 'controller')");
  $stmt->execute([$controller_id, $site_id, $title, $description, $photo_path, $video_path]);

  // Log notification
  $note = $pdo->prepare("INSERT INTO notifications (message, type, link, created_at) VALUES (?, 'incident', ?, NOW())");
  $note->execute(["New incident from controller: $title", 'admin/incident_reports.php']);

  $success = "✅ Incident submitted successfully!";
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Submit Incident</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/controller_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    body {
      background: #f3f4f6;
    }
    .report-form {
      background: white;
      padding: 2rem;
      border-radius: 1rem;
      box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
    }
    .report-form h4 {
      font-weight: bold;
    }
  </style>
</head>
<body>
<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">

    <h4>🚨 Report Incident</h4>
    <hr>
    <?php if ($success): ?>
      <div class="alert alert-success"><?= $success ?></div>
    <?php elseif ($error): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

 
        <div class="col-md-8 col-lg-9">
          <div class="report-form">
              <h4 class="mb-6 text-center"></i>📝 Report Incident</h4>
              
                <form method="post" enctype="multipart/form-data">
                  <div class="mb-3">
                  <label class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" required>
                  </div>

                  <div class="mb-3">
                    <label>Description</label>
                    <textarea name="description" class="form-control" required></textarea>
                  </div>

                  <div class="mb-3">
                    <label>Site</label>
                    <select name="site_id" class="form-select" required>
                      <option value="">Select Site</option>
                      <?php foreach ($sites as $s): ?>
                        <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['site_name']) ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <div class="mb-3">
                    <label>Photo</label>
                    <input type="file" name="photo" class="form-control">
                  </div>

                  <div class="mb-3">
                    <label>Video</label>
                    <input type="file" name="video" class="form-control">
                  </div>

                  <button class="btn btn-primary">Submit</button>
                </form>
          </div>
        </div>
    

</div>
</div>
</body>
</html>
