<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
    header("Location: ../auth/login.php");
    exit;
}

$controller_id = $_SESSION['user_id'];
$controller_name = $_SESSION['username'] ?? 'Controller';
$date = date('Y-m-d');
$time = date('H:i:s');

$last_id = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = trim($_POST['subject'] ?? '');
    $details = trim($_POST['details'] ?? '');

    if ($subject && $details) {
        // Insert without serial_number
        $stmt = $pdo->prepare("INSERT INTO occurrences (controller_id, title, details, date, time) VALUES (?, ?, ?, ?, ?)");
        if ($stmt->execute([$controller_id, $subject, $details, $date, $time])) {
            $success = "Occurrence recorded successfully.";
            $last_id = $pdo->lastInsertId();
        } else {
            $error = "Failed to record occurrence.";
        }
    } else {
        $error = "Subject and occurrence details are required.";
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Record Occurrence</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body { background: #f4f6f9; }
    .card { margin-top: 40px; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar_controller.php'; ?>
  <?php include '../includes/sidebar_controller.php'; ?>

<div class="content-wrapper">
    <div class="container">
        <div class="card">
          <div class="card-header bg-primary text-white">
            <h5 class="mb-0">📝 Record Daily Occurrence</h5>
          </div>
          <div class="card-body">
            <?php if (!empty($success)): ?>
              <div class="alert alert-success d-flex justify-content-between align-items-center">
                <?= htmlspecialchars($success) ?>
                <?php if ($last_id): ?>
                  <a href="print_occurrence.php?id=<?= $last_id ?>" class="btn btn-sm btn-outline-success"><i class="fas fa-print"></i> Print</a>
                <?php endif; ?>
              </div>
            <?php elseif (!empty($error)): ?>
              <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="POST">
              <div class="row mb-3">
                <div class="col-md-3">
                  <label class="form-label">Controller Name</label>
                  <input type="text" class="form-control" value="<?= htmlspecialchars($controller_name) ?>" readonly>
                </div>
                <div class="col-md-3">
                  <label class="form-label">Date</label>
                  <input type="text" class="form-control" value="<?= $date ?>" readonly>
                </div>
                <div class="col-md-3">
                  <label class="form-label">Time</label>
                  <input type="text" class="form-control" value="<?= $time ?>" readonly>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">Subject</label>
                <input type="text" name="subject" class="form-control" required placeholder="Enter subject of occurrence">
              </div>

              <div class="mb-3">
                <label class="form-label">Occurrence Details</label>
                <textarea name="details" class="form-control" rows="6" required placeholder="Describe what happened..."></textarea>
              </div>

              <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Submit</button>
              <a href="dashboard.php" class="btn btn-secondary">Back</a>
            </form>
          </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

</body>
</html>
