<?php
session_start();
require_once '../includes/config.php';

try {
    $reportNumber = $_POST['report_number'] ?? '';
    $reportDate = $_POST['report_date'] ?? '';
    $reportTime = $_POST['report_time'] ?? '';
    $informantName = $_POST['informant_name'] ?? '';
    $contactNo = $_POST['contact_no'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $recordingOfficer = $_POST['recording_officer'] ?? '';

    if (!$reportNumber || !$reportDate || !$reportTime || !$informantName || !$subject) {
        $_SESSION['toast'] = ['message' => '❌ Missing required fields.'];
        header("Location: report_incident.php");
        exit;
    }

    $photoDir = '../uploads/incidents/photos/';
    $videoDir = '../uploads/incidents/videos/';
    @mkdir($photoDir, 0777, true);
    @mkdir($videoDir, 0777, true);

    $photos = [];
    if (!empty($_FILES['photos']['name'][0])) {
        foreach ($_FILES['photos']['name'] as $i => $name) {
            $tmp = $_FILES['photos']['tmp_name'][$i];
            $error = $_FILES['photos']['error'][$i];
            if ($error === UPLOAD_ERR_OK && is_uploaded_file($tmp)) {
                $newName = time() . '_' . basename($name);
                if (move_uploaded_file($tmp, $photoDir . $newName)) {
                    $photos[] = $newName;
                }
            }
        }
    }

    $videos = [];
    if (!empty($_FILES['videos']['name'][0])) {
        foreach ($_FILES['videos']['name'] as $i => $name) {
            $tmp = $_FILES['videos']['tmp_name'][$i];
            $error = $_FILES['videos']['error'][$i];
            if ($error === UPLOAD_ERR_OK && is_uploaded_file($tmp)) {
                $newName = time() . '_' . basename($name);
                if (move_uploaded_file($tmp, $videoDir . $newName)) {
                    $videos[] = $newName;
                } else {
                    $_SESSION['toast'] = ['message' => '❌ Failed to move uploaded video.'];
                    header("Location: report_incident.php");
                    exit;
                }
            } elseif ($error !== UPLOAD_ERR_NO_FILE) {
                $_SESSION['toast'] = ['message' => '❌ Error uploading one of the videos.'];
                header("Location: report_incident.php");
                exit;
            }
        }
    }

    $stmt = $pdo->prepare("INSERT INTO incident_reports (
        report_number, incident_date, incident_time, informant_name,
        contact_no, title, recording_officer, photo, video,
        submitted_by_role, reported_at
    ) VALUES (
        :report_number, :incident_date, :incident_time, :informant_name,
        :contact_no, :title, :recording_officer, :photo, :video,
        'officer', NOW()
    )");

    $stmt->execute([
        ':report_number' => $reportNumber,
        ':incident_date' => $reportDate,
        ':incident_time' => $reportTime,
        ':informant_name' => $informantName,
        ':contact_no' => $contactNo,
        ':title' => $subject,
        ':recording_officer' => $recordingOfficer,
        ':photo' => json_encode($photos),
        ':video' => json_encode($videos)
    ]);

    $_SESSION['toast'] = ['message' => '✅ Incident report submitted successfully.'];
    header("Location: view_incidents_paginated.php");
    exit;

} catch (Exception $e) {
    $_SESSION['toast'] = ['message' => '❌ Error: ' . $e->getMessage()];
    header("Location: report_incident.php");
    exit;
}
?>
