<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
    header("Location: ../auth/login.php");
    exit;
}

$stmt = $pdo->prepare("
  SELECT 
    i.report_number, i.title, i.description, i.status, i.reported_at,
    i.photo, i.video, s.site_name,
    u.username AS officer_name, c.username AS controller_name
  FROM incident_reports i
  LEFT JOIN users u ON i.officer_id = u.id
  LEFT JOIN controllers c ON i.controller_id = c.id
  LEFT JOIN sites s ON i.site_id = s.id
  WHERE i.controller_id = ?
  ORDER BY i.created_at DESC
");
$stmt->execute([$_SESSION['user_id']]);
$incidents = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Controller - Incident View</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-4">
  <h4>Submitted Incidents</h4>
  <table class="table table-bordered table-striped mt-3">
    <thead class="table-dark"><tr><th>Report #</th><th>Title</th><th>Site</th><th>Status</th><th>Reported At</th><th>Action</th></tr></thead>
    <tbody>
    <?php foreach ($incidents as $i): ?>
      <tr>
        <td><?= htmlspecialchars($i['report_number']) ?></td>
        <td><?= htmlspecialchars($i['title']) ?></td>
        <td><?= htmlspecialchars($i['site_name']) ?></td>
        <td><?= ucfirst($i['status']) ?></td>
        <td><?= $i['reported_at'] ?></td>
        <td>
          <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modal<?= md5($i['report_number']) ?>">View</button>
        </td>
      </tr>
      <div class="modal fade" id="modal<?= md5($i['report_number']) ?>" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header bg-dark text-white">
              <h5 class="modal-title">Incident Details</h5>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <p><strong>Title:</strong> <?= htmlspecialchars($i['title']) ?></p>
              <p><strong>Description:</strong><br><?= nl2br(htmlspecialchars($i['description'])) ?></p>
              <p><strong>Submitted By:</strong> <?= $i['controller_name'] ?? $i['officer_name'] ?></p>
              <p><strong>Site:</strong> <?= htmlspecialchars($i['site_name']) ?></p>
              <p><strong>Status:</strong> <?= ucfirst($i['status']) ?></p>
              <p><strong>Reported At:</strong> <?= $i['reported_at'] ?></p>
              <?php if (!empty($i['photo'])): ?>
                <div class="row mt-3">
                  <?php foreach (json_decode($i['photo']) as $p): ?>
                    <div class="col-md-4 mb-2">
                      <a href="../uploads/<?= $p ?>" target="_blank">
                        <img src="../uploads/<?= $p ?>" class="img-fluid border rounded" />
                      </a>
                    </div>
                  <?php endforeach; ?>
                </div>
              <?php endif; ?>
              <?php if (!empty($i['video'])): ?>
                <div class="mt-3">
                  <video controls class="w-100 rounded border" style="max-height:300px;">
                    <source src="../uploads/<?= $i['video'] ?>" type="video/mp4">
                  </video>
                </div>
              <?php endif; ?>
            </div>
            <div class="modal-footer">
              <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
