<?php
require_once '../includes/config.php';

$err = "";
$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = $_POST['username'];
  $email = $_POST['email'];
  $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
  $role = $_POST['role'];
  $admin_key = $_POST['admin_key'] ?? '';

  if ($role === 'admin' && $admin_key !== 'ADMIN_123') {
    $err = "Invalid secret key for admin registration.";
  } else {
    // ✅ Check for duplicate username or email
    $check = $pdo->prepare("SELECT * FROM users WHERE username = ? OR email = ?");
    $check->execute([$username, $email]);

    if ($check->rowCount() > 0) {
      $err = "Username or Email already exists.";
    } else {
      $stmt = $pdo->prepare("INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, ?)");
      $stmt->execute([$username, $email, $password, $role]);
      $success = "Registration successful. You can now login.";
    }
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register | CFS System OS</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #003366, #0059b3);
      color: #fff;
      font-family: 'Segoe UI', sans-serif;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .card {
      border: none;
      border-radius: 20px;
      padding: 30px;
      background-color: #f9f9f9;
      color: #333;
      box-shadow: 0 0 30px rgba(0,0,0,0.2);
      width: 420px;
    }
    .btn-primary {
      border-radius: 12px;
      background-color: #0059b3;
    }
    .btn-primary:hover {
      background-color: #003366;
    }
    .form-control {
      border-radius: 12px;
    }
    .form-select {
      border-radius: 12px;
    }
    .text-link {
      color: #007bff;
    }
    .text-link:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<div class="card">
  <h4 class="text-center mb-3">📝 Register - CFS System OS</h4>

  <?php if ($err): ?><div class="alert alert-danger"><?= $err ?></div><?php endif; ?>
  <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>

  <form method="post">
    <div class="mb-3">
      <label>Username</label>
      <input type="text" name="username" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>Email</label>
      <input type="email" name="email" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>Password</label>
      <input type="password" name="password" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>Register As</label>
      <select name="role" class="form-select" onchange="document.getElementById('admin_key_field').style.display = this.value === 'admin' ? 'block' : 'none';" required>
        <option value="">Select Role</option>
        <option value="officer">Officer</option>
        <option value="admin">Admin</option>
        <option value="controller">controller</option>
      </select>
    </div>
    <div class="mb-3" id="admin_key_field" style="display:none;">
      <label>Admin Secret Key</label>
      <input type="text" name="admin_key" class="form-control">
    </div>
    <div class="d-grid">
      <button class="btn btn-primary">Register</button>
    </div>
    <div class="text-center mt-3">
      <a href="login.php" class="text-link">Already have an account? Login</a>
    </div>
  </form>
</div>

</body>
</html>
