<?php
require '../includes/db_config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

$officer_id = $data['officer_id'];
$biometric_type = $data['type']; // 'face' or 'fingerprint'
$biometric_token = $data['token'];

// Update the appropriate biometric token field
$field = $biometric_type === 'face' ? 'face_biometric_token' : 'fingerprint_biometric_token';

$sql = "UPDATE officers SET $field = ?, biometric_status = 'pending' WHERE id = ?";
$stmt = $pdo->prepare($sql);
if ($stmt->execute([$biometric_token, $officer_id])) {
    echo json_encode(["status" => "success", "message" => "Biometric submitted for approval"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update"]);
}
