<?php
header('Content-Type: application/json');
require_once '../includes/config.php';

$stmt = $pdo->query("
  SELECT DATE(reported_at) as date, COUNT(*) as total
  FROM incident_reports
  GROUP BY DATE(reported_at)
  ORDER BY DATE(reported_at) DESC
  LIMIT 7
");

$data = $stmt->fetchAll(PDO::FETCH_ASSOC);
$labels = array_reverse(array_column($data, 'date'));
$counts = array_reverse(array_map('intval', array_column($data, 'total')));

echo json_encode([
  'labels' => $labels,
  'counts' => $counts
]);
?>
