<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch KET records
$stmt = $pdo->query("
  SELECT e.*, u.username 
  FROM employment_terms e
  JOIN users u ON e.officer_id = u.id
  ORDER BY e.created_at DESC
");
$kets = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View Employment Terms | CFS System OS</title>
  <meta charset="UTF-8" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>
<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">
        <div class="container mt-4">
        <h4>📑 Employment Terms Records</h4>

        <div class="table-responsive mt-3">
            <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                <th>#</th>
                <th>Officer</th>
                <th>Position</th>
                <th>Start</th>
                <th>End</th>
                <th>Contract</th>
                <th>Uploaded On</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($kets as $i => $row): ?>
                <tr>
                <td><?= $i + 1 ?></td>
                <td><?= htmlspecialchars($row['username']) ?></td>
                <td><?= htmlspecialchars($row['position']) ?></td>
                <td><?= $row['start_date'] ?></td>
                <td><?= $row['end_date'] ?></td>
                <td>
                    <?php if ($row['contract_file']): ?>
                    <a href="../uploads/kets/<?= $row['contract_file'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                        View PDF
                    </a>
                    <?php else: ?>
                    <span class="text-muted">No file</span>
                    <?php endif; ?>
                </td>
                <td><?= $row['created_at'] ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($kets)): ?>
                <tr><td colspan="7" class="text-center text-muted">No employment terms found.</td></tr>
                <?php endif; ?>
            </tbody>
            </table>
        </div>
        </div>
</div>
</body>
</html>
