<?php
header('Content-Type: application/json');
require_once '../includes/config.php';

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['id'], $data['type'], $data['start'])) {
    echo json_encode(['success' => false, 'error' => 'Missing fields']);
    exit;
}

try {
    if ($data['type'] === 'attendance') {
        $stmt = $pdo->prepare("UPDATE attendance SET date = :date WHERE id = :id");
        $stmt->execute([':date' => $data['start'], ':id' => $data['id']]);
    } elseif ($data['type'] === 'leave') {
        $stmt = $pdo->prepare("UPDATE leave_requests SET start_date = :start, end_date = :end WHERE id = :id");
        $stmt->execute([':start' => $data['start'], ':end' => $data['end'], ':id' => $data['id']]);
    }
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>