<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

if ($action === 'add') {
  $stmt = $pdo->prepare("INSERT INTO sites (site_name, location, contact_person, contact_number) VALUES (?, ?, ?, ?)");
  $stmt->execute([$_POST['site_name'], $_POST['location'], $_POST['contact_person'], $_POST['contact_number']]);
} elseif ($action === 'update' && $id) {
  $stmt = $pdo->prepare("UPDATE sites SET site_name=?, location=?, contact_person=?, contact_number=? WHERE id=?");
  $stmt->execute([$_POST['site_name'], $_POST['location'], $_POST['contact_person'], $_POST['contact_number'], $id]);
} elseif ($action === 'delete' && $id) {
  $pdo->prepare("DELETE FROM sites WHERE id=?")->execute([$id]);
}

header("Location: sites.php");
exit;
