<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'controller'])) {
    header("Location: ../auth/login.php");
    exit;
}

$stmt = $pdo->query("
  SELECT o.*, u.username AS controller_name
  FROM occurrences o
  JOIN users u ON o.controller_id = u.id
  ORDER BY o.date DESC, o.time DESC
");
$occurrences = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Occurrence Summary</title>

  <!-- AdminLTE & Bootstrap -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <style>
    .content-wrapper { background-color: #f4f6f9; }
  </style>
  
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

 
  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>
  
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <h4 class="mb-0">📘 Occurrence Summary</h4>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="card mt-3">
          <div class="card-body table-responsive">
            <table id="occurrenceTable" class="table table-bordered table-striped table-sm text-sm">
              <thead class="table-dark">
                <tr>
                  <th>#</th>
                  <th>Date</th>
                  <th>Time</th>
                  <th>Title</th>
                  <th>Details</th>
                  <th>Controller</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($occurrences as $i => $row): ?>
                <tr>
                  <td><?= $i + 1 ?></td>
                  <td><?= htmlspecialchars($row['date']) ?></td>
                  <td><?= htmlspecialchars($row['time']) ?></td>
                  <td><?= htmlspecialchars($row['title']) ?></td>
                  <td><?= nl2br(htmlspecialchars($row['details'])) ?></td>
                  <td><?= htmlspecialchars($row['controller_name']) ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($occurrences)): ?>
                <tr><td colspan="7" class="text-center text-muted">No occurrence records found.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </section>
  </div>

  <?php include '../includes/footer.php'; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script>
  $(document).ready(function () {
    $('#occurrenceTable').DataTable();
  });
</script>
</body>
</html>
