<?php
session_start();
require_once '../includes/config.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $officer_id = $_POST['officer_id'];
    $site_id = $_POST['site_id'];
    $shift_date = $_POST['shift_date'];
    $shift_start = $_POST['shift_start'];
    $shift_end = $_POST['shift_end'];

    $stmt = $pdo->prepare("INSERT INTO roster (officer_id, site_id, shift_date, shift_start, shift_end) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$officer_id, $site_id, $shift_date, $shift_start, $shift_end]);

    $success = "Roster assigned successfully!";
}

// Fetch dropdown data
$officers = $pdo->query("SELECT id, name FROM officers WHERE status='active'")->fetchAll();
$sites = $pdo->query("SELECT id, site_name FROM sites")->fetchAll();
$rosters = $pdo->query("
    SELECT r.*, o.name AS officer_name, s.site_name 
    FROM roster r 
    JOIN officers o ON r.officer_id = o.id 
    JOIN sites s ON r.site_id = s.id
    ORDER BY r.shift_date DESC
")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Roster Management</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>

<?php include '../includes/navbar.php'; ?>
<div class="container-fluid mt-4">
  <div class="row">
    <div class="col-md-2">
      <?php include '../includes/sidebar_admin.php'; ?>
    </div>
    <div class="col-md-10">
      <h4>📋 Roster Management</h4>

      <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?= $success ?></div>
      <?php endif; ?>

      <form method="post" class="row g-3">
        <div class="col-md-3">
          <label>Officer</label>
          <select name="officer_id" class="form-control" required>
            <option value="">Select Officer</option>
            <?php foreach ($officers as $o): ?>
              <option value="<?= $o['id'] ?>"><?= htmlspecialchars($o['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label>Site</label>
          <select name="site_id" class="form-control" required>
            <option value="">Select Site</option>
            <?php foreach ($sites as $s): ?>
              <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['site_name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label>Date</label>
          <input type="date" name="shift_date" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label>Shift Start</label>
          <input type="time" name="shift_start" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label>Shift End</label>
          <input type="time" name="shift_end" class="form-control" required>
        </div>
        <div class="col-md-12 text-end">
          <button class="btn btn-primary">Assign Roster</button>
        </div>
      </form>

      <hr class="my-4">

      <h5>🗓 Assigned Roster</h5>
      <table class="table table-bordered mt-3">
        <thead class="table-dark">
          <tr>
            <th>Date</th>
            <th>Officer</th>
            <th>Site</th>
            <th>Start</th>
            <th>End</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rosters as $r): ?>
            <tr>
              <td><?= $r['shift_date'] ?></td>
              <td><?= htmlspecialchars($r['officer_name']) ?></td>
              <td><?= htmlspecialchars($r['site_name']) ?></td>
              <td><?= $r['shift_start'] ?></td>
              <td><?= $r['shift_end'] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>

    </div>
  </div>
</div>

</body>
</html>
