<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'controller')) {
    header("Location: ../auth/login.php");
    exit;
}

if (!isset($_GET['id'])) {
    header("Location: view_incidents.php?error=No incident selected");
    exit;
}

$incident_id = (int)$_GET['id'];

$stmt = $pdo->prepare("
    SELECT ir.*, s.site_name 
    FROM incident_reports ir
    LEFT JOIN sites s ON ir.site_id = s.id
    WHERE ir.id = ?
");
$stmt->execute([$incident_id]);
$incident = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$incident) {
    header("Location: view_incidents.php?error=Incident not found");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Incident Details</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body { background-color: #f5f9fc; font-family: 'Segoe UI', sans-serif; }
    .card { border-radius: 10px; }
    .card-header { border-bottom: none; }
    .img-preview { max-width: 200px; margin-bottom: 10px; }
    video { max-width: 400px; margin-bottom: 10px; }
    dl.row { margin-bottom: 0; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>

  <div class="content-wrapper">
        <div class="container py-4">
          <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
              <h5 class="mb-0">🚨 Incident Report Details</h5>
            </div>

            <div class="card-body">
              <dl class="row">
                <dt class="col-sm-4">Report Number</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['report_number'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Subject</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['subject'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Site</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['site_name'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Date</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['incident_date'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Time</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['incident_time'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Informant</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['informant_name'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Contact Number</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['contact_no'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Recording Officer</dt>
                <dd class="col-sm-8"><?= htmlspecialchars($incident['recording_officer'] ?? 'N/A') ?></dd>

                <dt class="col-sm-4">Description</dt>
                <dd class="col-sm-8"><?= nl2br(htmlspecialchars($incident['description'] ?? 'N/A')) ?></dd>

                <dt class="col-sm-4">Photo(s)</dt>
                <dd class="col-sm-8">
                  <?php if (!empty($incident['photo'])): ?>
                    <?php foreach (explode(',', $incident['photo']) as $photo): ?>
                      <img src="<?= trim($photo) ?>" alt="Incident Photo" class="img-fluid img-preview rounded">
                    <?php endforeach; ?>
                  <?php else: ?>
                    <span class="text-muted">No photos available</span>
                  <?php endif; ?>
                </dd>

                <dt class="col-sm-4">Video(s)</dt>
                <dd class="col-sm-8">
                  <?php if (!empty($incident['video'])): ?>
                    <?php foreach (explode(',', $incident['video']) as $video): ?>
                      <video src="<?= trim($video) ?>" controls class="w-100"></video>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <span class="text-muted">No videos available</span>
                  <?php endif; ?>
                </dd>
              </dl>
            </div>

            <div class="card-footer text-end">
              <a href="incident_reports.php" class="btn btn-secondary">← Back to Incidents</a>
            </div>
          </div>
        </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

</body>
</html>
