<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$id = $_GET['id'] ?? null;
if (!$id || !is_numeric($id)) {
    header("Location: view_attendance.php");
    exit;
}

// Fetch record
$stmt = $pdo->prepare("SELECT * FROM attendance WHERE id = ?");
$stmt->execute([$id]);
$record = $stmt->fetch();

if (!$record) {
    echo "Record not found.";
    exit;
}

// Generate CSRF token if not set
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        die("Invalid CSRF token.");
    }

    $time_in  = $_POST['time_in'] ?? null;
    $time_out = $_POST['time_out'] ?? null;
    $gps_in   = $_POST['gps_in'] ?? null;
    $gps_out  = $_POST['gps_out'] ?? null;

    $update = $pdo->prepare("UPDATE attendance SET time_in = ?, time_out = ?, gps_in = ?, gps_out = ? WHERE id = ?");
    $update->execute([$time_in, $time_out, $gps_in, $gps_out, $id]);

    $_SESSION['success'] = "Attendance updated successfully.";
    header("Location: view_attendance.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Attendance | CFS System OS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-5">
    <div class="card shadow">
      <div class="card-header bg-primary text-white">
        <h4 class="mb-0">✏️ Edit Attendance Record</h4>
      </div>
      <div class="card-body">
        <form method="POST">
          <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">

          <div class="mb-3">
            <label class="form-label">Date</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($record['date']) ?>" readonly>
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Time In</label>
              <input type="time" name="time_in" class="form-control" value="<?= htmlspecialchars($record['time_in']) ?>">
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Time Out</label>
              <input type="time" name="time_out" class="form-control" value="<?= htmlspecialchars($record['time_out']) ?>">
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">GPS In</label>
              <input type="text" name="gps_in" class="form-control" value="<?= htmlspecialchars($record['gps_in']) ?>">
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">GPS Out</label>
              <input type="text" name="gps_out" class="form-control" value="<?= htmlspecialchars($record['gps_out']) ?>">
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <a href="view_attendance.php" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Update Record</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <?php if (!empty($_SESSION['success'])): ?>
  <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1055">
    <div class="toast show bg-success text-white" role="alert">
      <div class="toast-header bg-success text-white">
        <strong class="me-auto">Success</strong>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
      </div>
      <div class="toast-body">
        <?= $_SESSION['success'] ?>
      </div>
    </div>
  </div>
  <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
