<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$id = $_GET['id'] ?? null;
if (!$id) {
  header("Location: view_attendance.php");
  exit;
}

// Optional: Validate if record exists
$stmt = $pdo->prepare("SELECT * FROM attendance WHERE id = ?");
$stmt->execute([$id]);
$record = $stmt->fetch();

if ($record) {
  $del = $pdo->prepare("DELETE FROM attendance WHERE id = ?");
  $del->execute([$id]);
}

header("Location: view_attendance.php");
exit;
?>
