<?php
require_once '../includes/config.php';

$type = $_GET['type'] ?? '';

if ($type === 'leaves') {
  $leaves = $pdo->query("
    SELECT l.*, u.username 
    FROM leave_requests l 
    JOIN users u ON l.officer_id = u.id 
    ORDER BY l.created_at DESC LIMIT 5
  ")->fetchAll();

 foreach ($leaves as $lv) {
  $status = $lv['status'];
  if ($status === 'approved') {
    $badge = 'success';
  } elseif ($status === 'rejected') {
    $badge = 'danger';
  } else {
    $badge = 'warning';
  }

  echo "<li class='list-group-item d-flex justify-content-between'>
    <span><strong>{$lv['username']}</strong> - " . ucfirst($lv['leave_type']) . "</span>
    <span class='badge bg-$badge'>" . ucfirst($status) . "</span>
  </li>";
}
  echo "<div class='text-end mt-2'><a href='view_leave_requests.php' class='btn btn-sm btn-outline-info'>View All</a></div>";
}

if ($type === 'sites') {
  $sites = $pdo->query("SELECT site_name, location FROM sites ORDER BY created_at DESC LIMIT 5")->fetchAll();

  foreach ($sites as $s) {
    echo "<li class='list-group-item'>
      <strong>{$s['site_name']}</strong><br><small class='text-muted'>{$s['location']}</small>
    </li>";
  }

  echo "<div class='text-end mt-2'><a href='manage_sites.php' class='btn btn-sm btn-outline-primary'>Manage Sites</a></div>";
}

if ($type === 'kets') {
  $kets = $pdo->query("
    SELECT et.*, u.username 
    FROM employment_terms et 
    JOIN users u ON et.officer_id = u.id 
    ORDER BY et.created_at DESC LIMIT 5
  ")->fetchAll();

  foreach ($kets as $k) {
    echo "<li class='list-group-item d-flex justify-content-between'>
      <span><strong>{$k['username']}</strong></span>
      <span class='text-muted'>" . date('d M Y', strtotime($k['created_at'])) . "</span>
    </li>";
  }

  echo "<div class='text-end mt-2'><a href='employment_terms.php' class='btn btn-sm btn-outline-dark'>View All</a></div>";
}
