<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$sites = $pdo->query("SELECT * FROM sites ORDER BY id DESC")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Deployment Sites</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">
  <div class="container mt-4">
    <h4>📍 Deployment Sites</h4>

    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addSiteModal">➕ Add Site</button>

    <table class="table table-bordered table-striped">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Site Name</th>
          <th>Location</th>
          <th>Contact Person</th>
          <th>Contact Number</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($sites as $i => $site): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($site['site_name']) ?></td>
          <td><?= htmlspecialchars($site['location']) ?></td>
          <td><?= htmlspecialchars($site['contact_person']) ?></td>
          <td><?= htmlspecialchars($site['contact_number']) ?></td>
          <td>
            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editSite<?= $site['id'] ?>">✏️</button>
            <form method="post" action="sites_action.php" class="d-inline" onsubmit="return confirm('Delete this site?');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?= $site['id'] ?>">
              <button class="btn btn-sm btn-danger">🗑</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Add Site Modal -->
<div class="modal fade" id="addSiteModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" action="sites_action.php" class="modal-content">
      <input type="hidden" name="action" value="add">
      <div class="modal-header">
        <h5 class="modal-title">Add Deployment Site</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input name="site_name" class="form-control mb-2" placeholder="Site Name" required>
        <textarea name="location" class="form-control mb-2" placeholder="Location"></textarea>
        <input name="contact_person" class="form-control mb-2" placeholder="Contact Person">
        <input name="contact_number" class="form-control mb-2" placeholder="Contact Number">
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary">Add Site</button>
      </div>
    </form>
  </div>
</div>

<!-- Edit Modals -->
<?php foreach ($sites as $site): ?>
<div class="modal fade" id="editSite<?= $site['id'] ?>" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" action="sites_action.php" class="modal-content">
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="id" value="<?= $site['id'] ?>">
      <div class="modal-header">
        <h5 class="modal-title">Edit Site</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input name="site_name" class="form-control mb-2" value="<?= htmlspecialchars($site['site_name']) ?>" required>
        <textarea name="location" class="form-control mb-2"><?= htmlspecialchars($site['location']) ?></textarea>
        <input name="contact_person" class="form-control mb-2" value="<?= htmlspecialchars($site['contact_person']) ?>">
        <input name="contact_number" class="form-control mb-2" value="<?= htmlspecialchars($site['contact_number']) ?>">
      </div>
      <div class="modal-footer">
        <button class="btn btn-success">Update</button>
      </div>
    </form>
  </div>
</div>
<?php endforeach; ?>

</body>
</html>
