<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch KETs
$query = "
  SELECT et.*, u.username 
  FROM employment_terms et
  JOIN users u ON et.officer_id = u.id
  ORDER BY et.created_at DESC
";
$rows = $pdo->query($query)->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Employment Terms | CFS System OS</title>
  <meta charset="UTF-8">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content p-4">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4>📄 Employment Terms (KET)</h4>
    <a href="upload_employment_term.php" class="btn btn-success"><i class="fas fa-upload"></i> Upload New KET</a>
  </div>

  <div class="table-responsive">
    <table class="table table-striped table-bordered align-middle">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Position</th>
          <th>Start</th>
          <th>End</th>
          <th>Contract</th>
          <th>Uploaded On</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $i => $row): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($row['username']) ?></td>
          <td><?= htmlspecialchars($row['position']) ?></td>
          <td><?= $row['start_date'] ?></td>
          <td><?= $row['end_date'] ?></td>
          <td>
            <?php if (!empty($row['contract_file'])): ?>
              <a href="../uploads/kets/<?= $row['contract_file'] ?>" target="_blank" class="btn btn-sm btn-primary">
                <i class="fas fa-file-pdf"></i> View
              </a>
            <?php else: ?>
              <span class="text-muted">No file</span>
            <?php endif; ?>
          </td>
          <td><?= $row['created_at'] ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
        <tr><td colspan="7" class="text-center text-muted">No employment terms found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
  const ctx = document.getElementById('trendChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: <?= $trendLabels ?>,
      datasets: [{
        label: 'Check-ins',
        data: <?= $trendCounts ?>,
        backgroundColor: '#004080',
        borderRadius: 8
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 1 }
        }
      }
    }
  });
</script>

</body>
</html>
