<?php
require_once '../includes/config.php';

// On-Duty
$onDuty = $pdo->query("
  SELECT u.username, a.time_in 
  FROM attendance a
  JOIN users u ON a.officer_id = u.id
  WHERE DATE(a.time_in) = CURDATE()
  ORDER BY a.time_in DESC
")->fetchAll();

// Events
$events = $pdo->query("SELECT * FROM incident_reports ORDER BY reported_at DESC LIMIT 5")->fetchAll();

// Alerts
$alerts = $pdo->query("SELECT * FROM incident_reports WHERE status = 'pending' ORDER BY reported_at DESC LIMIT 5")->fetchAll();

// Notifications
$notifications = $pdo->query("SELECT * FROM notifications ORDER BY created_at DESC LIMIT 10")->fetchAll();
?>

<!-- On-Duty -->
<div class="col-md-6">
  <div class="card p-3">
    <h6>✅ On-Duty Officers</h6>
    <ul class="list-group">
      <?php foreach ($onDuty as $o): ?>
        <li class="list-group-item d-flex justify-content-between align-items-center">
          <?= htmlspecialchars($o['username']) ?>
          <span class="badge bg-primary"><?= date('H:i', strtotime($o['time_in'])) ?></span>
        </li>
      <?php endforeach; ?>
      <?php if (empty($onDuty)): ?>
        <li class="list-group-item text-muted">No officers on duty</li>
      <?php endif; ?>
    </ul>
  </div>
</div>

<!-- Site Events -->
<div class="col-md-6">
  <div class="card p-3">
    <h6>📍 Recent Site Events</h6>
    <ul class="list-group">
      <?php foreach ($events as $e): ?>
        <li class="list-group-item">
          <strong><?= htmlspecialchars($e['title']) ?></strong><br>
          <small><?= date('M d, H:i', strtotime($e['reported_at'])) ?></small>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
</div>

<!-- Emergency Alerts -->
<div class="col-md-6">
  <div class="card p-3">
    <h6 class="text-danger">🚨 Emergency Alerts</h6>
    <ul class="list-group">
      <?php foreach ($alerts as $a): ?>
        <li class="list-group-item live-alert">
          <strong><?= htmlspecialchars($a['title']) ?></strong><br>
          <small><?= date('M d, H:i', strtotime($a['reported_at'])) ?></small>
        </li>
      <?php endforeach; ?>
      <?php if (empty($alerts)): ?>
        <li class="list-group-item text-muted">No emergency alerts</li>
      <?php endif; ?>
    </ul>
  </div>
</div>

<!-- Notifications -->
<div class="col-md-6">
  <div class="card p-3">
    <h6>🔔 Live Notifications</h6>
    <ul class="list-group small">
      <?php foreach ($notifications as $n): ?>
        <li class="list-group-item">
          <?= htmlspecialchars($n['message']) ?><br>
          <small class="text-muted"><?= date('M d, H:i', strtotime($n['created_at'])) ?></small>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
</div>
