<?php
// Determine toast type and style
$type = '';
$icon = '';
$toastClass = 'bg-secondary';

if (!empty($_SESSION['success'])) {
  $type = $_SESSION['success'];
  $icon = '✅';
  $toastClass = 'bg-success';
} elseif (!empty($_SESSION['error'])) {
  $type = $_SESSION['error'];
  $icon = '❌';
  $toastClass = 'bg-danger';
} elseif (!empty($_SESSION['info'])) {
  $type = $_SESSION['info'];
  $icon = 'ℹ️';
  $toastClass = 'bg-info text-dark';
} elseif (!empty($_SESSION['warning'])) {
  $type = $_SESSION['warning'];
  $icon = '⚠️';
  $toastClass = 'bg-warning text-dark';
}
?>

<?php if (!empty($type)): ?>
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1080">
  <div class="toast align-items-center text-white <?= $toastClass ?> border-0 show" role="alert" aria-live="assertive" aria-atomic="true" id="liveToast">
    <div class="d-flex">
      <div class="toast-body">
        <?= $icon ?> <?= $type ?>
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>
<script>
  setTimeout(() => {
    const toast = document.getElementById('liveToast');
    if (toast) {
      toast.classList.remove('show');
    }
  }, 5000);
</script>
<?php
unset($_SESSION['success'], $_SESSION['error'], $_SESSION['info'], $_SESSION['warning']);
endif;
?>
