<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
  header("Location: ../auth/login.php");
  exit;
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

if ($action === 'add') {
  $officer_id = $_POST['officer_id'];
  $site_id = $_POST['site_id'];
  $shift_date = $_POST['shift_date'];
  $shift_type = $_POST['shift_type'];

  $stmt = $pdo->prepare("INSERT INTO roster (officer_id, site_id, shift_date, shift_type) VALUES (?, ?, ?, ?)");
  $stmt->execute([$officer_id, $site_id, $shift_date, $shift_type]);

} elseif ($action === 'update' && $id) {
  $officer_id = $_POST['officer_id'];
  $site_id = $_POST['site_id'];
  $shift_date = $_POST['shift_date'];
  $shift_type = $_POST['shift_type'];

  $stmt = $pdo->prepare("UPDATE roster SET officer_id = ?, site_id = ?, shift_date = ?, shift_type = ? WHERE id = ?");
  $stmt->execute([$officer_id, $site_id, $shift_date, $shift_type, $id]);

} elseif ($action === 'delete' && $id) {
  $stmt = $pdo->prepare("DELETE FROM roster WHERE id = ?");
  $stmt->execute([$id]);
}

header("Location: manage_roster.php");
exit;
