<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch data
$rosters = $pdo->query("
  SELECT r.*, u.username, s.site_name 
  FROM roster r
  JOIN users u ON r.officer_id = u.id
  JOIN sites s ON r.site_id = s.id
  ORDER BY r.shift_date DESC
")->fetchAll();

$officers = $pdo->query("SELECT id, username FROM users WHERE role = 'officer'")->fetchAll();
$sites = $pdo->query("SELECT id, site_name FROM sites ORDER BY site_name")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Manage Roster</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/controller_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">
<div class="container mt-4">
  <h4 class="mb-3">🗓️ Manage Officer Roster</h4>

  <button class="btn btn-primary btn-sm mb-3" data-bs-toggle="modal" data-bs-target="#addModal">➕ Assign Shift</button>

  <table class="table table-bordered table-sm table-striped">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>Officer</th>
        <th>Site</th>
        <th>Date</th>
        <th>Shift</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rosters as $i => $r): ?>
      <tr>
        <td><?= $i + 1 ?></td>
        <td><?= htmlspecialchars($r['username']) ?></td>
        <td><?= htmlspecialchars($r['site_name']) ?></td>
        <td><?= $r['shift_date'] ?></td>
        <td><?= ucfirst($r['shift_type']) ?></td>
        <td>
          <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?= $r['id'] ?>">✏️</button>
          <form action="roster_action.php" method="post" class="d-inline" onsubmit="return confirm('Delete this shift?');">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <button class="btn btn-danger btn-sm">🗑️</button>
          </form>
        </td>
      </tr>

      <!-- Edit Modal -->
      <div class="modal fade" id="editModal<?= $r['id'] ?>" tabindex="-1">
        <div class="modal-dialog">
          <form action="roster_action.php" method="post" class="modal-content">
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <div class="modal-header">
              <h5 class="modal-title">Edit Roster</h5>
              <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <select name="officer_id" class="form-select mb-2" required>
                <?php foreach ($officers as $o): ?>
                  <option value="<?= $o['id'] ?>" <?= $o['id'] == $r['officer_id'] ? 'selected' : '' ?>><?= htmlspecialchars($o['username']) ?></option>
                <?php endforeach; ?>
              </select>
              <select name="site_id" class="form-select mb-2" required>
                <?php foreach ($sites as $s): ?>
                  <option value="<?= $s['id'] ?>" <?= $s['id'] == $r['site_id'] ? 'selected' : '' ?>><?= htmlspecialchars($s['site_name']) ?></option>
                <?php endforeach; ?>
              </select>
              <input type="date" name="shift_date" class="form-control mb-2" value="<?= $r['shift_date'] ?>" required>
              <select name="shift_type" class="form-select" required>
                <option value="day" <?= $r['shift_type'] === 'day' ? 'selected' : '' ?>>Day</option>
                <option value="night" <?= $r['shift_type'] === 'night' ? 'selected' : '' ?>>Night</option>
              </select>
            </div>
            <div class="modal-footer">
              <button class="btn btn-success btn-sm">Update</button>
            </div>
          </form>
        </div>
      </div>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
  <div class="modal-dialog">
    <form action="roster_action.php" method="post" class="modal-content">
      <input type="hidden" name="action" value="add">
      <div class="modal-header">
        <h5 class="modal-title">Assign New Shift</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <select name="officer_id" class="form-select mb-2" required>
          <option value="">-- Select Officer --</option>
          <?php foreach ($officers as $o): ?>
            <option value="<?= $o['id'] ?>"><?= htmlspecialchars($o['username']) ?></option>
          <?php endforeach; ?>
        </select>
        <select name="site_id" class="form-select mb-2" required>
          <option value="">-- Select Site --</option>
          <?php foreach ($sites as $s): ?>
            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['site_name']) ?></option>
          <?php endforeach; ?>
        </select>
        <input type="date" name="shift_date" class="form-control mb-2" required>
        <select name="shift_type" class="form-select" required>
          <option value="day">Day</option>
          <option value="night">Night</option>
        </select>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary btn-sm">Add Shift</button>
      </div>
    </form>
  </div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
