<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$users = $pdo->query("SELECT * FROM users ORDER BY id DESC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Manage Users</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <style>
    .content-wrapper { background-color: #f4f6f9; }
    .modal-header { background-color: #007bff; color: white; }
    img.profile-preview { border-radius: 50%; width: 50px; height: 50px; object-fit: cover; }
    form.d-inline { display: inline-block; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid d-flex justify-content-between align-items-center">
      <h4 class="mb-0">👥 Manage Users</h4>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal"><i class="fas fa-user-plus"></i> Add User</button>
    </div>
  </div>

  <div class="content">
    <div class="container-fluid">

      <?php if (isset($_GET['deleted'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          ✅ User deleted successfully.
          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header bg-primary text-white">
          <h5 class="card-title">All Users</h5>
        </div>
        <div class="card-body table-responsive">
          <table id="userTable" class="table table-bordered table-striped text-sm">
            <thead class="table-dark">
              <tr>
                <th>Profile</th>
                <th>Username</th>
                <th>Email</th>
                <th>Contact</th>
                <th>Role</th>
                <th>Status</th>
                <th>Employment</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($users as $user): ?>
              <tr>
                <td>
                  <?php if (!empty($user['profile_image'])): ?>
                    <img src="../uploads/users/<?= $user['profile_image'] ?>" class="profile-preview" alt="Profile">
                  <?php else: ?>
                    <i class="fas fa-user-circle fa-2x text-secondary"></i>
                  <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($user['username']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['contact'] ?? '-') ?></td>
                <td><?= htmlspecialchars($user['role']) ?></td>
                <td>
                  <?php if ($user['status'] === 'active'): ?>
                    <span class="badge bg-success">Active</span>
                  <?php else: ?>
                    <span class="badge bg-secondary">Inactive</span>
                  <?php endif; ?>
                </td>
                <td>
                  <span class="badge <?= $user['officer_status'] === 'Full-Time' ? 'bg-primary' : 'bg-warning' ?>">
                    <?= $user['officer_status'] ?>
                  </span>
                </td>
                <td>
                  <button class="btn btn-sm btn-info editUserBtn"
                    data-id="<?= $user['id'] ?>"
                    data-username="<?= htmlspecialchars($user['username']) ?>"
                    data-email="<?= htmlspecialchars($user['email']) ?>"
                    data-contact="<?= htmlspecialchars($user['contact'] ?? '') ?>"
                    data-role="<?= $user['role'] ?>"
                    data-status="<?= $user['status'] ?>"
                    data-officer_status="<?= $user['officer_status'] ?>"
                    data-image="<?= $user['profile_image'] ?>"
                    data-bs-toggle="modal"
                    data-bs-target="#editUserModal">
                    <i class="fas fa-edit"></i> Edit
                  </button>
                  <form action="delete_user.php" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this user?');">
                    <input type="hidden" name="id" value="<?= $user['id'] ?>">
                    <button type="submit" name="delete_user" class="btn btn-sm btn-danger">
                      <i class="fas fa-trash-alt"></i> Delete
                    </button>
                  </form>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Edit User Modal -->
<div class="modal fade" id="editUserModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <form action="update_user.php" method="POST" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit User Profile</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body row g-3">
        <input type="hidden" name="id" id="editUserId">
        <div class="col-md-6">
          <label class="form-label">Username</label>
          <input type="text" name="username" id="editUsername" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input type="email" name="email" id="editEmail" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Contact</label>
          <input type="text" name="contact" id="editContact" class="form-control">
        </div>
        <div class="col-md-6">
          <label class="form-label">Role</label>
          <select name="role" id="editRole" class="form-control">
            <option value="admin">Admin</option>
            <option value="controller">Controller</option>
            <option value="officer">Officer</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Status</label>
          <select name="status" id="editStatus" class="form-control">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Employment</label>
          <select name="officer_status" id="editOfficerStatus" class="form-control">
            <option value="Full-Time">Full-Time</option>
            <option value="Ad-Hoc">Ad-Hoc</option>
          </select>
        </div>
        <div class="col-md-12">
          <label class="form-label">Profile Picture</label><br>
          <img id="editPreviewImage" src="" width="80" class="mb-2 rounded" style="display: none;">
          <input type="file" name="profile_image" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="update_user" class="btn btn-primary">Save Changes</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<!-- Add User Modal -->
<div class="modal fade" id="addUserModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <form action="add_user.php" method="POST" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add New User</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body row g-3">
        <div class="col-md-6">
          <label class="form-label">Username</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Password</label>
          <input type="password" name="password" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Contact</label>
          <input type="text" name="contact" class="form-control">
        </div>
        <div class="col-md-6">
          <label class="form-label">Role</label>
          <select name="role" class="form-control">
            <option value="admin">Admin</option>
            <option value="controller">Controller</option>
            <option value="officer">Officer</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Status</label>
          <select name="status" class="form-control">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Employment</label>
          <select name="officer_status" class="form-control">
            <option value="Full-Time">Full-Time</option>
            <option value="Ad-Hoc">Ad-Hoc</option>
          </select>
        </div>
        <div class="col-md-12">
          <label class="form-label">Profile Picture</label>
          <input type="file" name="profile_image" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="add_user" class="btn btn-success">Create User</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script>
  $(document).ready(function () {
    $('#userTable').DataTable();

    $('.editUserBtn').click(function () {
      const btn = $(this);
      $('#editUserId').val(btn.data('id'));
      $('#editUsername').val(btn.data('username'));
      $('#editEmail').val(btn.data('email'));
      $('#editContact').val(btn.data('contact'));
      $('#editRole').val(btn.data('role'));
      $('#editStatus').val(btn.data('status'));
      $('#editOfficerStatus').val(btn.data('officer_status'));
      const image = btn.data('image');
      if (image) {
        $('#editPreviewImage').attr('src', '../uploads/users/' + image).show();
      } else {
        $('#editPreviewImage').hide();
      }
    });
  });
</script>
</body>
</html>
