<?php
require '../includes/config.php';

$pending = $pdo->query("SELECT * FROM officers WHERE biometric_status = 'pending'")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Biometric Requests</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
  <h3 class="mb-4">🧬 Pending Biometric Approvals</h3>
  <table class="table table-bordered">
    <thead>
      <tr>
        <th>Name</th>
        <th>Email</th>
        <th>Face Biometric</th>
        <th>Fingerprint</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($pending as $o): ?>
      <tr>
        <td><?= htmlspecialchars($o['name']) ?></td>
        <td><?= htmlspecialchars($o['email']) ?></td>
        <td><?= $o['face_biometric_token'] ? 'Submitted' : '-' ?></td>
        <td><?= $o['fingerprint_biometric_token'] ? 'Submitted' : '-' ?></td>
        <td>
          <form method="post" action="process_biometric.php" class="d-flex gap-1">
            <input type="hidden" name="officer_id" value="<?= $o['id'] ?>">
            <button name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
            <button name="action" value="reject" class="btn btn-danger btn-sm">Reject</button>
          </form>
        </td>
      </tr>
      <?php endforeach ?>
    </tbody>
  </table>
</body>
</html>
