<?php
declare(strict_types=1);
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/auth.php';

ensure_session();

// If already logged in, route to correct dashboard
if (is_logged_in()) {
    $roles = $_SESSION['user']['roles'] ?? [];
    if (in_array('admin', $roles, true)) header('Location: admin/dashboard.php');
    elseif (in_array('hr', $roles, true)) header('Location: hr/dashboard.php');
    elseif (in_array('manager', $roles, true)) header('Location: manager/dashboard.php');
    elseif (in_array('supervisor', $roles, true)) header('Location: supervisor/dashboard.php');
    elseif (in_array('controller', $roles, true)) header('Location: controller/dashboard.php');
    else header('Location: guard/dashboard.php');
    exit;
}

$error = '';
$email_prefill = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_validate($_POST['_csrf'] ?? null);

    $email = trim((string)($_POST['email'] ?? ''));
    $pass  = (string)($_POST['password'] ?? '');
    $email_prefill = $email;

    $stmt = db()->prepare("SELECT * FROM users WHERE email = ? AND status = 'active' LIMIT 1");
    $stmt->execute([$email]);
    $u = $stmt->fetch();

    if ($u && password_verify($pass, $u['password_hash'])) {
        $_SESSION['user'] = [
            'id' => (int)$u['id'],
            'full_name' => $u['full_name'],
            'email' => $u['email'],
            'roles' => load_user_roles((int)$u['id']),
        ];
        db()->prepare("UPDATE users SET last_login_at = NOW() WHERE id = ?")->execute([(int)$u['id']]);

        // redirect by role (GuardPro feel)
        $roles = $_SESSION['user']['roles'];
        if (in_array('admin', $roles, true)) header('Location: admin/dashboard.php');
        elseif (in_array('hr', $roles, true)) header('Location: hr/dashboard.php');
        elseif (in_array('manager', $roles, true)) header('Location: manager/dashboard.php');
        elseif (in_array('supervisor', $roles, true)) header('Location: supervisor/dashboard.php');
        elseif (in_array('controller', $roles, true)) header('Location: controller/dashboard.php');
        else header('Location: guard/dashboard.php');
        exit;
    }

    $error = 'Invalid email or password.';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= APP_NAME ?> | Secure Console Login</title>

  <!-- AdminLTE + deps -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">

  <!-- PWA -->
  <link rel="manifest" href="manifest.json">
  <meta name="theme-color" content="#0B0F19">

  <style>
    :root{
      --bg0:#06080f;
      --bg1:#0b1020;
      --bg2:#101a2b;
      --hud:#00e5ff;
      --hud2:#2aff7a;
      --gold:#C9A24D;
      --muted:rgba(255,255,255,.75);
      --glass:rgba(255,255,255,.06);
      --line:rgba(255,255,255,.10);
      --shadow:0 26px 80px rgba(0,0,0,.70);
      --danger:#ff4d4f;
    }

    html,body{height:100%}
    body{
      margin:0;
      color:#fff;
      font-family:"Segoe UI", system-ui, -apple-system, Arial, sans-serif;
      background:
        radial-gradient(1200px 700px at 20% 10%, rgba(0,229,255,.10), transparent 55%),
        radial-gradient(900px 600px at 80% 30%, rgba(42,255,122,.08), transparent 55%),
        radial-gradient(1000px 700px at 50% 90%, rgba(201,162,77,.08), transparent 60%),
        linear-gradient(135deg, var(--bg0), var(--bg1) 55%, var(--bg2));
      overflow:hidden;
    }

    /* Layers */
    .layer{position:fixed; inset:0; pointer-events:none; z-index:0}

    .grid{
      background-image:
        linear-gradient(rgba(255,255,255,.06) 1px, transparent 1px),
        linear-gradient(90deg, rgba(255,255,255,.06) 1px, transparent 1px);
      background-size: 64px 64px;
      opacity:.35;
      transform: translate3d(0,0,0);
    }

    .scanlines{
      background: repeating-linear-gradient(
        to bottom,
        rgba(255,255,255,.035),
        rgba(255,255,255,.035) 1px,
        transparent 3px,
        transparent 6px
      );
      opacity:.18;
      mix-blend-mode: overlay;
    }

    /* Radar sweep */
    .sweep:before{
      content:"";
      position:absolute; inset:-20%;
      background: conic-gradient(from 0deg,
        rgba(0,229,255,0) 0deg,
        rgba(0,229,255,.20) 22deg,
        rgba(0,229,255,0) 55deg,
        rgba(0,229,255,0) 360deg
      );
      animation: radar 6.8s linear infinite;
      opacity:.45;
      transform-origin:center;
      mask-image: radial-gradient(circle at center, rgba(0,0,0,1) 0 34%, rgba(0,0,0,0) 62%);
      -webkit-mask-image: radial-gradient(circle at center, rgba(0,0,0,1) 0 34%, rgba(0,0,0,0) 62%);
    }
    @keyframes radar { to { transform: rotate(360deg); } }

    /* Floating beacons */
    .beacon{
      position:absolute;
      width:6px; height:6px;
      border-radius:50%;
      background: var(--hud2);
      box-shadow: 0 0 18px rgba(42,255,122,.75);
      opacity:.75;
      animation: rise linear infinite;
    }
    @keyframes rise{
      0%{ transform: translateY(0); opacity:0; }
      15%{ opacity:.85; }
      100%{ transform: translateY(-120vh); opacity:0; }
    }

    /* Layout */
    .wrap{
      position:relative;
      z-index:2;
      height:100%;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:24px 14px;
    }

    .frame{
      width:min(980px, 100%);
      display:grid;
      grid-template-columns: 1.15fr .85fr;
      border:1px solid var(--line);
      border-radius:20px;
      overflow:hidden;
      background: linear-gradient(180deg, rgba(255,255,255,.07), rgba(255,255,255,.04));
      backdrop-filter: blur(16px);
      box-shadow: var(--shadow);
      position:relative;
    }

    @media (max-width: 920px){
      .frame{ grid-template-columns: 1fr; }
      .left{ display:none; }
    }

    /* Corner brackets */
    .frame:before, .frame:after{
      content:"";
      position:absolute;
      width:120px; height:120px;
      border:2px solid rgba(0,229,255,.28);
      opacity:.65;
      pointer-events:none;
      z-index:1;
    }
    .frame:before{ left:14px; top:14px; border-right:none; border-bottom:none; border-radius:16px 0 0 0; }
    .frame:after{ right:14px; bottom:14px; border-left:none; border-top:none; border-radius:0 0 16px 0; }

    .left{
      padding:26px 22px;
      border-right:1px solid rgba(255,255,255,.08);
      background: rgba(0,0,0,.18);
      position:relative;
    }

    .brand{
      display:flex; align-items:center; gap:12px;
      position:relative; z-index:2;
    }
    .brand img{ width:52px; height:52px; object-fit:contain; }
    .brand .name{
      font-weight:900;
      font-size:18px;
      text-transform:uppercase;
      letter-spacing:.9px;
    }
    .brand .tag{
      font-size:12px;
      color: rgba(255,255,255,.7);
      margin-top:-2px;
      letter-spacing:.3px;
    }

    .status{
      margin-top:16px;
      display:flex; gap:10px; flex-wrap:wrap;
      position:relative; z-index:2;
    }
    .pill{
      font-size:12px;
      padding:6px 10px;
      border-radius:999px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.05);
      color: rgba(255,255,255,.85);
      display:flex; gap:8px; align-items:center;
      white-space:nowrap;
    }
    .dot{ width:8px; height:8px; border-radius:50%; background: var(--hud2); box-shadow: 0 0 10px rgba(42,255,122,.7); }
    .dot.hud{ background: var(--hud); box-shadow: 0 0 10px rgba(0,229,255,.7); }
    .dot.gold{ background: var(--gold); box-shadow: 0 0 10px rgba(201,162,77,.55); }

    .left h1{
      margin:22px 0 0;
      font-weight:900;
      font-size:40px;
      line-height:1.05;
      text-transform:uppercase;
      letter-spacing:1.2px;
      position:relative; z-index:2;
    }
    .left h1 span{
      color: var(--hud);
      text-shadow: 0 0 20px rgba(0,229,255,.22);
    }
    .left p{
      margin:14px 0 0;
      color: var(--muted);
      line-height:1.6;
      font-size:14px;
      max-width:56ch;
      position:relative; z-index:2;
    }

    .intel{
      margin-top:18px;
      display:grid;
      grid-template-columns: 1fr 1fr;
      gap:10px;
      position:relative; z-index:2;
    }
    .intel .box{
      border:1px solid rgba(255,255,255,.10);
      background: rgba(255,255,255,.04);
      border-radius:14px;
      padding:12px;
    }
    .intel .label{
      font-size:11px;
      color: rgba(255,255,255,.65);
      text-transform:uppercase;
      letter-spacing:.7px;
    }
    .intel .value{
      margin-top:6px;
      font-size:18px;
      font-weight:900;
      letter-spacing:.6px;
    }

    .left .hint{
      margin-top:14px;
      font-size:12px;
      color: rgba(255,255,255,.65);
      position:relative; z-index:2;
    }

    /* Right / Login panel */
    .right{
      padding:26px 22px;
      position:relative;
      z-index:2;
    }

    .right .title{
      font-weight:900;
      text-transform:uppercase;
      letter-spacing:1px;
      margin:0;
      font-size:16px;
    }
    .right .subtitle{
      margin:8px 0 0;
      font-size:13px;
      color: rgba(255,255,255,.70);
    }

    .alert-cmd{
      margin-top:14px;
      border:1px solid rgba(255,77,79,.30);
      background: rgba(255,77,79,.10);
      color:#ffd6d6;
      border-radius:14px;
      padding:10px 12px;
      font-size:13px;
    }

    .form{
      margin-top:16px;
    }

    .form-group label{
      font-size:11px;
      text-transform:uppercase;
      letter-spacing:.8px;
      color: rgba(255,255,255,.70);
      margin-bottom:6px;
    }

    .input-group .form-control{
      background: rgba(0,0,0,.18);
      border: 1px solid rgba(255,255,255,.14);
      color:#fff;
      border-right:none;
      border-radius:14px 0 0 14px;
      height:46px;
    }
    .input-group .form-control:focus{
      box-shadow:none;
      border-color: rgba(0,229,255,.45);
    }
    .input-group-text{
      background: rgba(0,0,0,.18);
      border: 1px solid rgba(255,255,255,.14);
      border-left:none;
      color: rgba(255,255,255,.85);
      border-radius:0 14px 14px 0;
      height:46px;
    }

    .btn-cmd{
      border:none;
      padding:12px 16px;
      border-radius:14px;
      font-weight:900;
      text-transform:uppercase;
      letter-spacing:.8px;
      transition:.2s ease;
      display:inline-flex;
      align-items:center;
      justify-content:center;
      gap:10px;
      width:100%;
    }
    .btn-primary-cmd{
      background: linear-gradient(135deg, rgba(0,229,255,.92), rgba(42,255,122,.70));
      color:#051018;
      box-shadow: 0 14px 34px rgba(0,229,255,.10);
    }
    .btn-primary-cmd:hover{ transform: translateY(-1px); filter: brightness(1.06); }

    .links{
      margin-top:14px;
      display:flex;
      justify-content:space-between;
      gap:10px;
      flex-wrap:wrap;
      font-size:12px;
      color: rgba(255,255,255,.65);
    }
    .links a{
      color: rgba(255,255,255,.78);
      text-decoration:none;
      border-bottom: 1px dashed rgba(0,229,255,.25);
      padding-bottom:2px;
    }
    .links a:hover{ color:#fff; border-bottom-color: rgba(0,229,255,.45); }

    .footer{
      margin-top:18px;
      font-size:11px;
      color: rgba(255,255,255,.55);
      text-align:center;
      border-top: 1px solid rgba(255,255,255,.08);
      padding-top:14px;
    }
    .footer .lock{
      color: var(--hud);
      margin-right:6px;
    }

    /* Small “typing” effect on left headline marker */
    .pulse{
      display:inline-block;
      border-bottom:1px dashed rgba(0,229,255,.35);
      padding-bottom:2px;
      animation: pulse 2.2s ease-in-out infinite;
    }
    @keyframes pulse{
      0%,100%{ filter: brightness(1); }
      50%{ filter: brightness(1.18); }
    }
  </style>
</head>

<body>
  <div class="layer grid" id="gridLayer"></div>
  <div class="layer sweep"></div>
  <div class="layer scanlines"></div>

  <script>
    // Floating beacons
    (function(){
      const count = 36;
      for(let i=0;i<count;i++){
        const b = document.createElement('div');
        b.className='beacon';
        b.style.left = (Math.random()*100) + '%';
        b.style.top  = (60 + Math.random()*60) + 'vh';
        b.style.animationDuration = (6 + Math.random()*10) + 's';
        b.style.animationDelay = (Math.random()*3) + 's';
        b.style.opacity = (0.30 + Math.random()*0.55);
        document.body.appendChild(b);
      }
    })();
  </script>

  <div class="wrap">
    <div class="frame" id="frame">

      <!-- LEFT COMMAND PANEL -->
      <div class="left">
        <div class="brand">
          <img src="assets/image/logo.jpg" alt="<?= APP_NAME ?>">
          <div>
            <div class="name"><?= APP_NAME ?></div>
            <div class="tag">Ultra Corporate • High-Tech Military Console</div>
          </div>
        </div>

        <div class="status">
          <div class="pill"><span class="dot hud"></span> System: Online</div>
          <div class="pill"><span class="dot"></span> Attendance: Live</div>
          <div class="pill"><span class="dot gold"></span> Secure Channel</div>
        </div>

        <h1>Secure <span class="pulse">Command</span><br>Access</h1>
        <p>
          Enter the operations console to manage roster deployment, attendance verification,
          patrol compliance, and incident intelligence across all client sites.
        </p>

        <div class="intel">
          <div class="box">
            <div class="label"><i class="fas fa-user-shield"></i> RBAC</div>
            <div class="value">ENFORCED</div>
          </div>
          <div class="box">
            <div class="label"><i class="fas fa-clipboard-check"></i> AUDIT</div>
            <div class="value">READY</div>
          </div>
          <div class="box">
            <div class="label"><i class="fas fa-route"></i> PATROL</div>
            <div class="value">QR + GPS</div>
          </div>
          <div class="box">
            <div class="label"><i class="fas fa-exclamation-triangle"></i> INCIDENTS</div>
            <div class="value">TRACKED</div>
          </div>
        </div>

        <div class="hint">
          <i class="fas fa-info-circle" style="color: var(--hud);"></i>
          Use your company-issued credentials. Access is logged and monitored.
        </div>
      </div>

      <!-- RIGHT LOGIN PANEL -->
      <div class="right">
        <h2 class="title">Operator Login</h2>
        <div class="subtitle">Authenticate to access your role dashboard (Admin/HR/Manager/Supervisor/Guard).</div>

        <?php if ($error): ?>
          <div class="alert-cmd">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($error) ?>
          </div>
        <?php endif; ?>

        <form class="form" method="post" autocomplete="off">
          <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

          <div class="form-group">
            <label>Email</label>
            <div class="input-group">
              <input
                type="email"
                name="email"
                class="form-control"
                placeholder="operator@company.com"
                required
                value="<?= htmlspecialchars($email_prefill) ?>"
              >
              <div class="input-group-append">
                <div class="input-group-text"><i class="fas fa-envelope"></i></div>
              </div>
            </div>
          </div>

          <div class="form-group">
            <label>Password</label>
            <div class="input-group">
              <input type="password" name="password" class="form-control" placeholder="••••••••" required>
              <div class="input-group-append">
                <div class="input-group-text"><i class="fas fa-lock"></i></div>
              </div>
            </div>
          </div>

          <button type="submit" class="btn-cmd btn-primary-cmd">
            <i class="fas fa-sign-in-alt"></i> Access Console
          </button>

          <div class="links">
            <a href="index.php"><i class="fas fa-arrow-left"></i> Back to Landing</a>
            <a href="register-admin.php"><i class="fas fa-user-shield"></i> Register Admin</a>
          </div>

          <div class="footer">
            <i class="fas fa-lock lock"></i>
            Secure channel • PWA enabled • <?= htmlspecialchars(APP_NAME) ?> © <?= date('Y') ?>
          </div>
        </form>
      </div>

    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/jquery/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

  <script>
    // Parallax grid + subtle frame movement
    (function(){
      const grid = document.getElementById('gridLayer');
      const frame = document.getElementById('frame');

      window.addEventListener('mousemove', (e)=>{
        const cx = window.innerWidth/2;
        const cy = window.innerHeight/2;
        const dx = (e.clientX - cx) / cx;
        const dy = (e.clientY - cy) / cy;

        grid.style.transform = `translate3d(${dx*10}px, ${dy*10}px, 0)`;
        frame.style.transform = `translate3d(${dx*4}px, ${dy*3}px, 0)`;
      }, {passive:true});
    })();

    // PWA
    if ('serviceWorker' in navigator) {
      navigator.serviceWorker.register('sw.js');
    }
  </script>
</body>
</html>