<?php
require_once __DIR__ . '/auth.php';
require_login();
$me = current_user();
$roles = $me['roles'] ?? [];

function role_badge(array $roles): string {
    $map = [
        'admin' => ['Administrator', 'badge-danger'],
        'hr' => ['HR', 'badge-info'],
        'manager' => ['Manager', 'badge-primary'],
        'supervisor' => ['Supervisor', 'badge-warning'],
        'controller' => ['Controller', 'badge-success'],
        'guard' => ['Guard', 'badge-secondary'],
    ];
    foreach ($map as $key => [$label, $class]) {
        if (in_array($key, $roles, true)) {
            return '<span class="badge '.$class.' badge-pill">'.$label.'</span>';
        }
    }
    return '<span class="badge badge-light badge-pill">User</span>';
}

$page_title = APP_NAME; // You can override per page by setting $page_title before include header.php
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?></title>

  <!-- AdminLTE + deps -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">

  <!-- Optional: DataTables/Toastr (safe to keep globally if you use them a lot) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/toastr/toastr.min.css">

  <style>
    :root{
      --bg0:#06080f;
      --bg1:#0b1020;
      --bg2:#101a2b;
      --hud:#00e5ff;
      --hud2:#2aff7a;
      --gold:#C9A24D;
      --line: rgba(255,255,255,.10);
      --muted: rgba(255,255,255,.72);
      --glass: rgba(255,255,255,.05);
      --glass2: rgba(255,255,255,.08);
    }

    /* Make AdminLTE feel like “command center” */
    body{
      background:
        radial-gradient(1200px 700px at 20% 10%, rgba(0,229,255,.08), transparent 55%),
        radial-gradient(900px 600px at 80% 30%, rgba(42,255,122,.06), transparent 55%),
        radial-gradient(1000px 700px at 50% 90%, rgba(201,162,77,.06), transparent 60%),
        linear-gradient(135deg, var(--bg0), var(--bg1) 55%, var(--bg2)) !important;
      color:#fff;
    }

    /* Navbar command style */
    .navbar.cmd-navbar{
      background: rgba(0,0,0,.28) !important;
      border-bottom: 1px solid rgba(255,255,255,.08);
      backdrop-filter: blur(12px);
    }
    .navbar.cmd-navbar .nav-link{
      color: rgba(255,255,255,.85) !important;
    }
    .navbar.cmd-navbar .nav-link:hover{
      color: #fff !important;
    }

    /* HUD brand in navbar */
    .cmd-brand{
      display:flex;
      align-items:center;
      gap:10px;
      margin-left:8px;
    }
    .cmd-brand .logo{
      width:28px; height:28px;
      object-fit:contain;
      filter: drop-shadow(0 0 8px rgba(0,229,255,.15));
    }
    .cmd-brand .name{
      font-weight:900;
      text-transform:uppercase;
      letter-spacing:.9px;
      font-size:13px;
      line-height:1;
    }
    .cmd-brand .tag{
      font-size:11px;
      color: rgba(255,255,255,.65);
      letter-spacing:.3px;
      margin-top:2px;
    }

    /* Pills */
    .cmd-pill{
      font-size:12px;
      padding:6px 10px;
      border-radius:999px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.04);
      color: rgba(255,255,255,.85);
      display:flex;
      align-items:center;
      gap:8px;
      white-space:nowrap;
    }
    .cmd-dot{ width:8px; height:8px; border-radius:50%; background: var(--hud2); box-shadow:0 0 10px rgba(42,255,122,.6); }
    .cmd-dot.hud{ background: var(--hud); box-shadow:0 0 10px rgba(0,229,255,.6); }
    .cmd-dot.gold{ background: var(--gold); box-shadow:0 0 10px rgba(201,162,77,.45); }

    /* Content wrapper glass */
    .content-wrapper{
      background: transparent !important;
    }
    .content-wrapper .container-fluid{
      padding-top: 8px;
    }

    /* Sidebar match theme (works with your sidebar.php) */
    .main-sidebar{
      background: rgba(0,0,0,.45) !important;
      border-right: 1px solid rgba(255,255,255,.08);
      backdrop-filter: blur(12px);
    }
    .brand-link{
      background: rgba(0,0,0,.20) !important;
      border-bottom: 1px solid rgba(255,255,255,.08) !important;
    }
    .brand-link .brand-text{
      font-weight:900;
      letter-spacing:.9px;
      text-transform:uppercase;
    }
    .nav-sidebar .nav-link{
      color: rgba(255,255,255,.78) !important;
      border-radius: 12px;
      margin: 2px 8px;
    }
    .nav-sidebar .nav-link.active{
      background: rgba(0,229,255,.14) !important;
      border: 1px solid rgba(0,229,255,.18);
      color:#fff !important;
    }
    .nav-sidebar .nav-link:hover{
      background: rgba(255,255,255,.06) !important;
      color:#fff !important;
    }

    /* Tiny scanline for premium feel */
    .cmd-scanline{
      position:absolute;
      left:-20%;
      top:0;
      width:140%;
      height:2px;
      background: linear-gradient(90deg, transparent, rgba(0,229,255,.55), transparent);
      opacity:.25;
      animation: scan 4s linear infinite;
      pointer-events:none;
    }
    @keyframes scan{
      0%{ transform: translateY(0); }
      100%{ transform: translateY(56px); }
    }

    /* Dropdown menu */
    .dropdown-menu.cmd-menu{
      background: rgba(10,14,26,.92);
      border: 1px solid rgba(255,255,255,.12);
      border-radius: 14px;
      backdrop-filter: blur(12px);
    }
    .dropdown-menu.cmd-menu .dropdown-item{
      color: rgba(255,255,255,.85);
    }
    .dropdown-menu.cmd-menu .dropdown-item:hover{
      background: rgba(0,229,255,.12);
      color:#fff;
    }

    /* Buttons */
    .btn-cmd-outline{
      border:1px solid rgba(255,255,255,.14);
      background: rgba(255,255,255,.04);
      color:#fff;
      border-radius: 12px;
    }
    .btn-cmd-outline:hover{
      background: rgba(255,255,255,.07);
      color:#fff;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <!-- NAVBAR -->
  <nav class="main-header navbar navbar-expand cmd-navbar position-relative">
    <div class="cmd-scanline"></div>

    <!-- Left: hamburger + brand -->
    <ul class="navbar-nav align-items-center">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button">
          <i class="fas fa-bars"></i>
        </a>
      </li>

      <li class="nav-item d-none d-md-block">
        <div class="cmd-brand">
          <img class="logo" src="<?= BASE_URL ?>/assets/image/logo.jpg" alt="<?= APP_NAME ?>">
          <div>
            <div class="name"><?= APP_NAME ?></div>
            <div class="tag">Command Console</div>
          </div>
        </div>
      </li>
    </ul>

    <!-- Right: status + profile -->
    <ul class="navbar-nav ml-auto align-items-center" style="gap:10px;">
      <li class="nav-item d-none d-lg-flex">
        <div class="cmd-pill"><span class="cmd-dot hud"></span> System Online</div>
      </li>
      <li class="nav-item d-none d-lg-flex">
        <div class="cmd-pill"><span class="cmd-dot"></span> Attendance Live</div>
      </li>
      <li class="nav-item d-none d-xl-flex">
        <div class="cmd-pill"><span class="cmd-dot gold"></span> Secure Channel</div>
      </li>

      <li class="nav-item dropdown">
        <a class="nav-link" data-toggle="dropdown" href="#" aria-expanded="false">
          <i class="fas fa-user-shield"></i>
          <span class="ml-1"><?= htmlspecialchars($me['full_name'] ?? '') ?></span>
        </a>
        <div class="dropdown-menu dropdown-menu-right cmd-menu">
          <span class="dropdown-item-text">
            <div style="font-weight:900; text-transform:uppercase; letter-spacing:.7px;">
              <?= htmlspecialchars($me['full_name'] ?? '') ?>
            </div>
            <div style="margin-top:6px;">
              <?= role_badge($roles) ?>
              <span class="ml-2" style="color: rgba(255,255,255,.65); font-size:12px;">
                <?= htmlspecialchars($me['email'] ?? '') ?>
              </span>
            </div>
          </span>
          <div class="dropdown-divider" style="border-color: rgba(255,255,255,.10);"></div>
          <a class="dropdown-item" href="<?= BASE_URL ?>/admin/dashboard.php">
            <i class="fas fa-tachometer-alt mr-2" style="color: var(--hud);"></i> Dashboard
          </a>
          <a class="dropdown-item" href="<?= BASE_URL ?>/logout.php">
            <i class="fas fa-sign-out-alt mr-2" style="color: #ff6b6b;"></i> Logout
          </a>
        </div>
      </li>
    </ul>
  </nav>

  <?php include __DIR__ . '/sidebar.php'; ?>

  <div class="content-wrapper">
    <section class="content pt-3">
      <div class="container-fluid">