<?php
// includes/footer.php (Ultra Corporate + High-Tech Military)
?>
      </div><!-- /.container-fluid -->
    </section><!-- /.content -->
  </div><!-- /.content-wrapper -->

  <style>
    :root{
      --hud:#00e5ff;
      --hud2:#2aff7a;
      --gold:#C9A24D;
      --line: rgba(255,255,255,.10);
      --muted: rgba(255,255,255,.68);
    }

    .cmd-footer{
      position: relative;
      border-top: 1px solid rgba(255,255,255,.08);
      background: rgba(0,0,0,.28);
      backdrop-filter: blur(12px);
      color: rgba(255,255,255,.78);
      padding: 12px 14px;
      overflow:hidden;
    }

    /* Subtle scanline */
    .cmd-footer:before{
      content:"";
      position:absolute;
      left:-20%;
      top:0;
      width:140%;
      height:2px;
      background: linear-gradient(90deg, transparent, rgba(0,229,255,.55), transparent);
      opacity:.22;
      animation: cmdFooterScan 4.6s linear infinite;
      pointer-events:none;
    }
    @keyframes cmdFooterScan{
      0%{ transform: translateY(0); }
      100%{ transform: translateY(44px); }
    }

    .cmd-footer-inner{
      position:relative;
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:12px;
      flex-wrap:wrap;
      font-size: 12px;
      letter-spacing:.25px;
    }

    .cmd-footer-left{
      display:flex;
      align-items:center;
      gap:10px;
      flex-wrap:wrap;
    }

    .cmd-badge{
      display:inline-flex;
      align-items:center;
      gap:8px;
      padding: 6px 10px;
      border-radius: 999px;
      border: 1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.04);
      color: rgba(255,255,255,.85);
      white-space:nowrap;
      font-size: 11px;
      text-transform: uppercase;
      letter-spacing:.7px;
    }

    .cmd-dot{ width:8px; height:8px; border-radius:50%; background: var(--hud2); box-shadow:0 0 10px rgba(42,255,122,.55); }
    .cmd-dot.hud{ background: var(--hud); box-shadow:0 0 10px rgba(0,229,255,.55); }
    .cmd-dot.gold{ background: var(--gold); box-shadow:0 0 10px rgba(201,162,77,.42); }

    .cmd-footer-right{
      display:flex;
      align-items:center;
      gap:10px;
      flex-wrap:wrap;
      color: var(--muted);
    }

    .cmd-link{
      color: rgba(255,255,255,.78);
      text-decoration:none;
      border-bottom: 1px dashed rgba(0,229,255,.25);
      padding-bottom:2px;
    }
    .cmd-link:hover{
      color:#fff;
      border-bottom-color: rgba(0,229,255,.45);
    }

    /* Small screen stacking */
    @media (max-width: 520px){
      .cmd-footer-inner{ justify-content:center; }
      .cmd-footer-left, .cmd-footer-right{ justify-content:center; }
    }
  </style>

  <footer class="main-footer cmd-footer">
    <div class="cmd-footer-inner">
      <div class="cmd-footer-left">
        <strong style="letter-spacing:.7px; text-transform:uppercase;">
          <?= htmlspecialchars(APP_NAME) ?> <span style="color: var(--muted); font-weight:500;">© <?= date('Y') ?></span>
        </strong>

        <span class="cmd-badge"><span class="cmd-dot hud"></span> System Online</span>
        <span class="cmd-badge"><span class="cmd-dot"></span> Live Ops</span>
        <span class="cmd-badge"><span class="cmd-dot gold"></span> Secure Channel</span>
      </div>

      <div class="cmd-footer-right">
        <span><i class="fas fa-shield-alt" style="color: var(--hud);"></i> Hardened Console</span>
        <span style="opacity:.65;">•</span>
        <a class="cmd-link" href="<?= BASE_URL ?>/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
      </div>
    </div>
  </footer>

</div><!-- /.wrapper -->

<!-- AdminLTE Scripts -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/jquery/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<!-- Optional: Toastr (if you use it) -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/toastr/toastr.min.js"></script>

<script>
  // PWA Service Worker (safe globally)
  if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('<?= BASE_URL ?>/sw.js');
  }
</script>

</body>
</html>