<?php
declare(strict_types=1);

/*
|--------------------------------------------------------------------------
| SecureHRMS - Hardened DB Configuration
|--------------------------------------------------------------------------
*/

const APP_NAME = 'SecureHRMS';
const BASE_URL = '';

/*
|--------------------------------------------------------------------------
| Database Credentials
|--------------------------------------------------------------------------
| IMPORTANT: In cPanel, DB name may be prefixed.
| Example: cpaneluser_dc2025_SecureHRMS
*/

const DB_HOST = 'localhost';
const DB_NAME = 'dc2025_SecureHRMS';
const DB_USER = 'dc2025_admin';
const DB_PASS = 'M1963@noor123';

/*
|--------------------------------------------------------------------------
| Error Handling
|--------------------------------------------------------------------------
*/

ini_set('display_errors', '0'); // NEVER show DB errors to public
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/../logs/php_error.log');

/*
|--------------------------------------------------------------------------
| Secure PDO Connection
|--------------------------------------------------------------------------
*/

function db(): PDO
{
    static $pdo = null;

    if ($pdo instanceof PDO) {
        return $pdo;
    }

    try {

        $dsn = sprintf(
            'mysql:host=%s;dbname=%s;charset=utf8mb4',
            DB_HOST,
            DB_NAME
        );

        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
            PDO::ATTR_STRINGIFY_FETCHES  => false,
        ]);

        // Verify correct database is selected
        $stmt = $pdo->query("SELECT DATABASE()");
        $currentDb = $stmt->fetchColumn();

        if ($currentDb !== DB_NAME) {
            throw new RuntimeException("Connected to wrong database: {$currentDb}");
        }

        // Verify roles table exists (system integrity check)
        $check = $pdo->query("SHOW TABLES LIKE 'roles'");
        if ($check->rowCount() === 0) {
            throw new RuntimeException("Critical table 'roles' missing.");
        }

        return $pdo;

    } catch (Throwable $e) {

        error_log("DB CONNECTION ERROR: " . $e->getMessage());

        http_response_code(500);
        exit('System database connection error. Contact administrator.');
    }
}