<?php
declare(strict_types=1);
require_once __DIR__ . '/_bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json_out(['ok'=>false,'error'=>'POST only'], 405);

$body = json_decode(file_get_contents('php://input'), true) ?: [];
$email = trim((string)($body['email'] ?? ''));
$pass  = (string)($body['password'] ?? '');
$deviceId = trim((string)($body['device_id'] ?? ''));

$stmt = db()->prepare("SELECT * FROM users WHERE email=? AND status='active' LIMIT 1");
$stmt->execute([$email]);
$u = $stmt->fetch();

if (!$u || !password_verify($pass, $u['password_hash'])) {
  json_out(['ok'=>false,'error'=>'Invalid credentials'], 401);
}

$plain = bin2hex(random_bytes(32));
$hash  = hash('sha256', $plain);
$expires = (new DateTime('+14 days'))->format('Y-m-d H:i:s');

db()->prepare("INSERT INTO api_tokens(user_id, token_hash, device_id, expires_at) VALUES(?,?,?,?)")
  ->execute([(int)$u['id'], $hash, $deviceId ?: null, $expires]);

json_out([
  'ok'=>true,
  'token'=>$plain,
  'user'=>['id'=>(int)$u['id'], 'full_name'=>$u['full_name'], 'email'=>$u['email']]
]);