<?php
declare(strict_types=1);
require_once __DIR__ . '/_bootstrap.php';
$me = api_auth_user();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json_out(['ok'=>false,'error'=>'POST only'], 405);

$userId = (int)$me['user_id'];
$siteId = (int)($_POST['site_id'] ?? 0);
$title = trim((string)($_POST['title'] ?? ''));
$desc = trim((string)($_POST['description'] ?? ''));
$category = $_POST['category'] ?? 'other';
$severity = $_POST['severity'] ?? 'low';
$incidentTime = $_POST['incident_time'] ?? (new DateTime())->format('Y-m-d H:i:s');

if ($siteId<=0 || $title==='' || $desc==='') json_out(['ok'=>false,'error'=>'Missing fields'], 422);

$stmt = db()->prepare("
  INSERT INTO incidents(site_id, reported_by, incident_time, category, severity, title, description, status)
  VALUES(?,?,?,?,?,?,?, 'open')
");
$stmt->execute([$siteId,$userId,$incidentTime,$category,$severity,$title,$desc]);
$incidentId = (int)db()->lastInsertId();

$dir = __DIR__ . '/../../assets/uploads/incidents/';
if (!is_dir($dir)) mkdir($dir, 0755, true);

if (!empty($_FILES['photos']) && is_array($_FILES['photos']['tmp_name'])) {
  for ($i=0; $i<count($_FILES['photos']['tmp_name']); $i++) {
    $tmp = $_FILES['photos']['tmp_name'][$i];
    if (!$tmp) continue;

    $ext = strtolower(pathinfo($_FILES['photos']['name'][$i], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png'], true)) continue;

    $fname = 'inc_' . $incidentId . '_' . time() . '_' . $i . '.' . $ext;
    $dest = $dir . $fname;
    if (move_uploaded_file($tmp, $dest)) {
      $path = 'assets/uploads/incidents/' . $fname;
      db()->prepare("INSERT INTO incident_photos(incident_id,file_path) VALUES(?,?)")->execute([$incidentId,$path]);
    }
  }
}

json_out(['ok'=>true,'incident_id'=>$incidentId]);