<?php
declare(strict_types=1);
require_once __DIR__ . '/_bootstrap.php';
$me = api_auth_user();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json_out(['ok'=>false,'error'=>'POST only'], 405);

$userId = (int)$me['user_id'];
$siteId = (int)($_POST['site_id'] ?? 0);
$lat = $_POST['geo_lat'] ?? null;
$lng = $_POST['geo_lng'] ?? null;
$acc = $_POST['accuracy_m'] ?? null;

if ($siteId <= 0) json_out(['ok'=>false,'error'=>'site_id required'], 422);

$photoPath = null;
if (!empty($_FILES['photo']['tmp_name'])) {
  $dir = __DIR__ . '/../../assets/uploads/attendance/';
  if (!is_dir($dir)) mkdir($dir, 0755, true);

  $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png'], true)) json_out(['ok'=>false,'error'=>'Invalid photo type'], 422);

  $fname = 'att_' . $userId . '_' . time() . '.' . $ext;
  $dest = $dir . $fname;
  if (!move_uploaded_file($_FILES['photo']['tmp_name'], $dest)) json_out(['ok'=>false,'error'=>'Upload failed'], 500);
  $photoPath = 'assets/uploads/attendance/' . $fname;
}

$stmt = db()->prepare("
  INSERT INTO attendance_logs(user_id, site_id, log_type, log_time, source, geo_lat, geo_lng, accuracy_m, photo_path)
  VALUES(?,?, 'check_in', NOW(), 'mobile', ?,?,?,?)
");
$stmt->execute([$userId,$siteId,$lat,$lng,$acc,$photoPath]);

json_out(['ok'=>true,'attendance_id'=>(int)db()->lastInsertId()]);