<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin']);

include __DIR__ . '/../includes/header.php';

// KPIs
$users    = (int) db()->query("SELECT COUNT(*) c FROM users")->fetch()['c'];
$sites    = (int) db()->query("SELECT COUNT(*) c FROM sites")->fetch()['c'];
$openInc  = (int) db()->query("SELECT COUNT(*) c FROM incidents WHERE status='open'")->fetch()['c'];

// Today metrics (optional but very “command center”)
$todayIn  = (int) db()->query("SELECT COUNT(*) c FROM attendance_logs WHERE log_type='check_in' AND DATE(log_time)=CURDATE()")->fetch()['c'];
$todayOut = (int) db()->query("SELECT COUNT(*) c FROM attendance_logs WHERE log_type='check_out' AND DATE(log_time)=CURDATE()")->fetch()['c'];
$incToday = (int) db()->query("SELECT COUNT(*) c FROM incidents WHERE DATE(created_at)=CURDATE()")->fetch()['c'];

// Recent incidents + activity
$recentInc = db()->query("
  SELECT i.id, i.title, i.severity, i.status, i.incident_time, s.site_name, u.full_name AS reporter
  FROM incidents i
  JOIN sites s ON s.id=i.site_id
  JOIN users u ON u.id=i.reported_by
  ORDER BY i.id DESC
  LIMIT 6
")->fetchAll();

$recentAtt = db()->query("
  SELECT a.id, a.log_type, a.log_time, s.site_name, u.full_name
  FROM attendance_logs a
  JOIN sites s ON s.id=a.site_id
  JOIN users u ON u.id=a.user_id
  ORDER BY a.id DESC
  LIMIT 8
")->fetchAll();

$me = current_user();
?>
<style>
  :root{
    --hud:#00e5ff;
    --hud2:#2aff7a;
    --gold:#C9A24D;
    --bg0:#06080f;
    --glass: rgba(255,255,255,.05);
    --glass2: rgba(255,255,255,.08);
    --line: rgba(255,255,255,.10);
    --muted: rgba(255,255,255,.70);
  }

  /* AdminLTE content wrapper is already present; we just style inside */
  .cmd-hero{
    border: 1px solid var(--line);
    background: linear-gradient(135deg, rgba(0,229,255,.08), rgba(42,255,122,.05), rgba(201,162,77,.05));
    border-radius: 18px;
    padding: 18px 18px;
    position: relative;
    overflow:hidden;
    box-shadow: 0 18px 50px rgba(0,0,0,.35);
  }
  .cmd-hero:before{
    content:"";
    position:absolute; inset:-30%;
    background:
      radial-gradient(900px 300px at 10% 20%, rgba(0,229,255,.18), transparent 60%),
      radial-gradient(900px 300px at 80% 10%, rgba(42,255,122,.12), transparent 60%),
      radial-gradient(900px 320px at 50% 90%, rgba(201,162,77,.10), transparent 60%);
    pointer-events:none;
  }
  .cmd-top{
    position:relative;
    display:flex;
    justify-content:space-between;
    align-items:flex-start;
    gap:12px;
    flex-wrap:wrap;
  }
  .cmd-title{
    margin:0;
    font-weight:900;
    letter-spacing: .9px;
    text-transform:uppercase;
    font-size: 18px;
  }
  .cmd-sub{
    margin:6px 0 0;
    color: var(--muted);
    font-size: 13px;
  }
  .cmd-pills{
    display:flex; gap:10px; flex-wrap:wrap; align-items:center;
  }
  .cmd-pill{
    font-size: 12px;
    padding: 7px 10px;
    border-radius: 999px;
    border: 1px solid rgba(255,255,255,.12);
    background: rgba(0,0,0,.18);
    color: rgba(255,255,255,.85);
    display:flex;
    align-items:center;
    gap:8px;
    white-space:nowrap;
  }
  .dot{ width:8px; height:8px; border-radius:50%; background: var(--hud2); box-shadow:0 0 10px rgba(42,255,122,.6); }
  .dot.hud{ background: var(--hud); box-shadow:0 0 10px rgba(0,229,255,.6); }
  .dot.gold{ background: var(--gold); box-shadow:0 0 10px rgba(201,162,77,.45); }

  .cmd-card{
    border: 1px solid var(--line);
    border-radius: 18px;
    background: rgba(0,0,0,.20);
    backdrop-filter: blur(10px);
    overflow:hidden;
    box-shadow: 0 16px 40px rgba(0,0,0,.25);
  }
  .cmd-card .card-header{
    border-bottom: 1px solid rgba(255,255,255,.08);
    background: rgba(0,0,0,.18);
  }
  .cmd-card .card-title{
    font-weight: 900;
    text-transform: uppercase;
    letter-spacing: .8px;
    font-size: 13px;
    margin:0;
  }
  .kpi-box{
    border:1px solid rgba(255,255,255,.10);
    background: rgba(255,255,255,.04);
    border-radius: 16px;
    padding: 14px;
    height: 100%;
    position:relative;
    overflow:hidden;
  }
  .kpi-box:before{
    content:"";
    position:absolute; inset:0;
    background: radial-gradient(500px 200px at 30% 0%, rgba(0,229,255,.10), transparent 60%);
    opacity:.7;
    pointer-events:none;
  }
  .kpi-head{
    position:relative;
    display:flex; align-items:center; justify-content:space-between;
    gap:12px;
  }
  .kpi-label{
    position:relative;
    font-size: 11px;
    color: rgba(255,255,255,.65);
    text-transform: uppercase;
    letter-spacing: .75px;
  }
  .kpi-value{
    position:relative;
    margin-top: 6px;
    font-size: 28px;
    font-weight: 900;
    letter-spacing: .6px;
  }
  .kpi-icon{
    width:42px; height:42px;
    border-radius: 14px;
    display:flex; align-items:center; justify-content:center;
    border:1px solid rgba(0,229,255,.20);
    background: rgba(0,229,255,.08);
    color: var(--hud);
    position:relative;
  }
  .kpi-foot{
    position:relative;
    margin-top: 8px;
    font-size: 12px;
    color: rgba(255,255,255,.70);
  }
  .badge-sev{
    padding: 4px 8px;
    border-radius: 999px;
    font-size: 11px;
    border: 1px solid rgba(255,255,255,.12);
    background: rgba(255,255,255,.05);
    text-transform: uppercase;
    letter-spacing:.5px;
  }
  .sev-low{ color:#b7f7c9; border-color: rgba(42,255,122,.25); background: rgba(42,255,122,.08); }
  .sev-medium{ color:#bde7ff; border-color: rgba(0,229,255,.25); background: rgba(0,229,255,.08); }
  .sev-high{ color:#ffe2a8; border-color: rgba(201,162,77,.25); background: rgba(201,162,77,.08); }
  .sev-critical{ color:#ffd0d0; border-color: rgba(255,77,79,.30); background: rgba(255,77,79,.10); }

  .table td, .table th{ border-top: 1px solid rgba(255,255,255,.08); }
  .table thead th{ border-bottom: 1px solid rgba(255,255,255,.10); }
  .text-muted2{ color: rgba(255,255,255,.65) !important; }

  /* optional tiny scanline across hero */
  .scanline{
    position:absolute;
    left:-20%;
    top:0;
    width:140%;
    height:2px;
    background: linear-gradient(90deg, transparent, rgba(0,229,255,.55), transparent);
    opacity:.35;
    animation: scan 3.6s linear infinite;
  }
  @keyframes scan{
    0%{ transform: translateY(0); }
    100%{ transform: translateY(160px); }
  }
</style>

<!-- HERO HEADER -->
<div class="cmd-hero mb-3">
  <div class="scanline"></div>
  <div class="cmd-top">
    <div>
      <h1 class="cmd-title">
        <i class="fas fa-shield-alt" style="color: var(--hud);"></i>
        Admin Command Console
      </h1>
      <div class="cmd-sub">
        Welcome, <b><?= htmlspecialchars($me['full_name'] ?? 'Administrator') ?></b> • Ops overview • Real-time control
      </div>
    </div>
    <div class="cmd-pills">
      <div class="cmd-pill"><span class="dot hud"></span> System: Online</div>
      <div class="cmd-pill"><span class="dot"></span> Attendance: Live</div>
      <div class="cmd-pill"><span class="dot gold"></span> Secure Channel</div>
    </div>
  </div>
</div>

<!-- KPI GRID -->
<div class="row">
  <div class="col-lg-3 col-md-6 mb-3">
    <div class="kpi-box">
      <div class="kpi-head">
        <div>
          <div class="kpi-label">Total Users</div>
          <div class="kpi-value"><?= $users ?></div>
        </div>
        <div class="kpi-icon"><i class="fas fa-users"></i></div>
      </div>
      <div class="kpi-foot"><span class="text-muted2">RBAC-enabled accounts</span></div>
    </div>
  </div>

  <div class="col-lg-3 col-md-6 mb-3">
    <div class="kpi-box">
      <div class="kpi-head">
        <div>
          <div class="kpi-label">Active Sites</div>
          <div class="kpi-value"><?= $sites ?></div>
        </div>
        <div class="kpi-icon" style="border-color: rgba(42,255,122,.22); background: rgba(42,255,122,.08); color: var(--hud2);">
          <i class="fas fa-building"></i>
        </div>
      </div>
      <div class="kpi-foot"><span class="text-muted2">Client operations footprint</span></div>
    </div>
  </div>

  <div class="col-lg-3 col-md-6 mb-3">
    <div class="kpi-box">
      <div class="kpi-head">
        <div>
          <div class="kpi-label">Open Incidents</div>
          <div class="kpi-value"><?= $openInc ?></div>
        </div>
        <div class="kpi-icon" style="border-color: rgba(201,162,77,.22); background: rgba(201,162,77,.08); color: var(--gold);">
          <i class="fas fa-exclamation-triangle"></i>
        </div>
      </div>
      <div class="kpi-foot"><span class="text-muted2">Requires review / closure</span></div>
    </div>
  </div>

  <div class="col-lg-3 col-md-6 mb-3">
    <div class="kpi-box">
      <div class="kpi-head">
        <div>
          <div class="kpi-label">Today Check-Ins</div>
          <div class="kpi-value"><?= $todayIn ?></div>
        </div>
        <div class="kpi-icon" style="border-color: rgba(0,229,255,.22); background: rgba(0,229,255,.08); color: var(--hud);">
          <i class="fas fa-user-clock"></i>
        </div>
      </div>
      <div class="kpi-foot"><span class="text-muted2">Out: <?= $todayOut ?> • New Inc: <?= $incToday ?></span></div>
    </div>
  </div>
</div>

<!-- COMMAND PANELS -->
<div class="row">
  <!-- Recent Incidents -->
  <div class="col-lg-7 mb-3">
    <div class="card cmd-card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-exclamation-triangle" style="color: var(--gold);"></i> Incident Intelligence (Latest)</h3>
        <div class="card-tools">
          <a href="<?= BASE_URL ?>/incidents/index.php" class="btn btn-sm btn-outline-light">
            View All
          </a>
        </div>
      </div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover mb-0">
            <thead>
              <tr>
                <th>ID</th>
                <th>Incident</th>
                <th>Site</th>
                <th>Severity</th>
                <th>Status</th>
                <th>Time</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!$recentInc): ?>
                <tr><td colspan="6" class="p-3 text-muted2">No incidents found.</td></tr>
              <?php else: ?>
                <?php foreach ($recentInc as $r):
                  $sev = (string)$r['severity'];
                  $sevClass = match ($sev) {
                    'low' => 'sev-low',
                    'medium' => 'sev-medium',
                    'high' => 'sev-high',
                    'critical' => 'sev-critical',
                    default => 'sev-medium'
                  };
                ?>
                <tr>
                  <td>#<?= (int)$r['id'] ?></td>
                  <td>
                    <div style="font-weight:800;"><?= htmlspecialchars($r['title']) ?></div>
                    <div class="text-muted2" style="font-size:12px;">
                      by <?= htmlspecialchars($r['reporter']) ?>
                    </div>
                  </td>
                  <td><?= htmlspecialchars($r['site_name']) ?></td>
                  <td><span class="badge-sev <?= $sevClass ?>"><?= htmlspecialchars($sev) ?></span></td>
                  <td class="text-muted2"><?= htmlspecialchars($r['status']) ?></td>
                  <td class="text-muted2"><?= htmlspecialchars((string)$r['incident_time']) ?></td>
                </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Recent Attendance Activity -->
  <div class="col-lg-5 mb-3">
    <div class="card cmd-card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-satellite-dish" style="color: var(--hud);"></i> Live Attendance Feed</h3>
        <div class="card-tools">
          <a href="<?= BASE_URL ?>/attendance/index.php" class="btn btn-sm btn-outline-light">
            Monitor
          </a>
        </div>
      </div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover mb-0">
            <thead>
              <tr>
                <th>Officer</th>
                <th>Site</th>
                <th>Type</th>
                <th>Time</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!$recentAtt): ?>
                <tr><td colspan="4" class="p-3 text-muted2">No attendance logs found.</td></tr>
              <?php else: ?>
                <?php foreach ($recentAtt as $a): ?>
                <tr>
                  <td style="font-weight:800;"><?= htmlspecialchars($a['full_name']) ?></td>
                  <td class="text-muted2"><?= htmlspecialchars($a['site_name']) ?></td>
                  <td>
                    <?php if ($a['log_type'] === 'check_in'): ?>
                      <span class="badge-sev sev-medium"><i class="fas fa-arrow-right"></i> IN</span>
                    <?php else: ?>
                      <span class="badge-sev sev-low"><i class="fas fa-arrow-left"></i> OUT</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-muted2"><?= htmlspecialchars((string)$a['log_time']) ?></td>
                </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Quick Actions -->
    <div class="card cmd-card mt-3">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-bolt" style="color: var(--hud2);"></i> Quick Actions</h3>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-6 mb-2">
            <a class="btn btn-block btn-outline-light" href="<?= BASE_URL ?>/users/add.php">
              <i class="fas fa-user-plus"></i> Add User
            </a>
          </div>
          <div class="col-6 mb-2">
            <a class="btn btn-block btn-outline-light" href="<?= BASE_URL ?>/clients/add.php">
              <i class="fas fa-building"></i> Add Client
            </a>
          </div>
          <div class="col-6 mb-2">
            <a class="btn btn-block btn-outline-light" href="<?= BASE_URL ?>/roster/index.php">
              <i class="fas fa-calendar-alt"></i> Roster
            </a>
          </div>
          <div class="col-6 mb-2">
            <a class="btn btn-block btn-outline-light" href="<?= BASE_URL ?>/patrol-routes/index.php">
              <i class="fas fa-route"></i> Patrol
            </a>
          </div>
        </div>
        <div class="text-muted2" style="font-size:12px; margin-top:8px;">
          <i class="fas fa-lock" style="color: var(--hud);"></i>
          Actions are permission-controlled (RBAC).
        </div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>