<?php

class RoleMiddleware extends Middleware
{
    private string $role;

    public function __construct(string $role)
    {
        $this->role = $role;
    }

    public function handle(): void
    {
        session_start();

        if (!isset($_SESSION['admin_role'])) {
            header("Location: /login");
            exit;
        }

        if ($_SESSION['admin_role'] !== $this->role) {
            http_response_code(403);
            die("Forbidden: Role access denied.");
        }
    }
}
