<?php
session_start();

require_once __DIR__ . '/../config/database.php';

$db = Database::connect();

// Fetch services
$services = $db->query("SELECT * FROM services ORDER BY id ASC")->fetchAll();

// Fetch zones
$zones = $db->query("SELECT * FROM zones ORDER BY id ASC")->fetchAll();

// CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Book Executive Transport | Exclusive Concierge</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/public.css">
</head>

<body class="bg-midnight text-light">

<nav class="navbar navbar-dark bg-midnight shadow-sm">
    <div class="container">
        <a href="index.php" class="navbar-brand">
            <span class="text-gold">Exclusive</span> Concierge
        </a>
    </div>
</nav>

<div class="container py-5">

    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="card bg-dark-slate shadow-lg">
                <div class="card-body p-4">

                    <h3 class="text-center text-gold mb-4">
                        Executive Booking
                    </h3>

                    <form id="bookingForm">

                        <input type="hidden" name="csrf_token"
                               value="<?php echo $_SESSION['csrf_token']; ?>">

                        <!-- Service -->
                        <div class="form-group">
                            <label>Service Type</label>
                            <select class="form-control"
                                    name="service_id"
                                    id="service_id"
                                    required>
                                <option value="">Select Service</option>
                                <?php foreach ($services as $service): ?>
                                    <option value="<?php echo $service['id']; ?>"
                                            data-pricing="<?php echo $service['pricing_type']; ?>">
                                        <?php echo htmlspecialchars($service['service_name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Zone -->
                        <div class="form-group d-none" id="zoneGroup">
                            <label>Pickup Zone</label>
                            <select class="form-control"
                                    name="zone_id"
                                    id="zone_id">
                                <option value="">Select Zone</option>
                                <?php foreach ($zones as $zone): ?>
                                    <option value="<?php echo $zone['id']; ?>">
                                        <?php echo htmlspecialchars($zone['zone_name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Hours -->
                        <div class="form-group d-none" id="hourGroup">
                            <label>Number of Hours</label>
                            <input type="number"
                                   class="form-control"
                                   name="hours"
                                   id="hours"
                                   min="1"
                                   value="1">
                        </div>

                        <!-- Vehicle -->
                        <div class="form-group">
                            <label>Vehicle Type</label>
                            <select class="form-control"
                                    name="vehicle_type"
                                    id="vehicle_type">
                                <option value="sedan">Sedan</option>
                                <option value="suv">SUV</option>
                                <option value="mpv">MPV</option>
                                <option value="limousine">Limousine</option>
                            </select>
                        </div>

                        <!-- Pickup -->
                        <div class="form-group">
                            <label>Pickup Address</label>
                            <input type="text"
                                   class="form-control"
                                   name="pickup_address"
                                   required>
                        </div>

                        <!-- Dropoff -->
                        <div class="form-group">
                            <label>Drop-off Address</label>
                            <input type="text"
                                   class="form-control"
                                   name="dropoff_address">
                        </div>

                        <!-- DateTime -->
                        <div class="form-group">
                            <label>Pickup Date & Time</label>
                            <input type="datetime-local"
                                   class="form-control"
                                   name="pickup_datetime"
                                   required>
                        </div>

                        <hr>

                        <!-- Customer Info -->
                        <h5 class="text-gold">Your Details</h5>

                        <div class="form-group">
                            <input type="text"
                                   class="form-control"
                                   name="name"
                                   placeholder="Full Name"
                                   required>
                        </div>

                        <div class="form-group">
                            <input type="email"
                                   class="form-control"
                                   name="email"
                                   placeholder="Email Address"
                                   required>
                        </div>

                        <div class="form-group">
                            <input type="text"
                                   class="form-control"
                                   name="phone"
                                   placeholder="Phone Number">
                        </div>

                        <hr>

                        <div class="text-center mb-3">
                            <h4>Total Estimated: 
                                <span class="text-gold" id="totalPrice">$0.00</span>
                            </h4>
                        </div>

                        <button type="submit"
                                class="btn btn-gold btn-block"
                                id="submitBooking">
                            Confirm Booking
                        </button>

                    </form>

                </div>
            </div>

        </div>
    </div>

</div>

<footer class="text-center py-4 bg-dark-slate">
    <small>
        &copy; <?php echo date('Y'); ?> Exclusive Concierge
    </small>
</footer>

<script src="assets/vendor/jquery/jquery.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/booking.js"></script>

</body>
</html>
