<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<div class="content-wrapper p-4">

    <section class="content">

        <div class="container-fluid">

            <h3 class="mb-4" style="font-family:'Playfair Display', serif;">
                Executive Dashboard Overview
            </h3>

            <!-- KPI CARDS -->
            <div class="row">

                <div class="col-lg-3 col-md-6">
                    <div class="card text-center p-3">
                        <div class="text-muted">Total Bookings</div>
                        <h2 id="totalBookings" class="counter mt-2">0</h2>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="card text-center p-3">
                        <div class="text-muted">Completed Bookings</div>
                        <h2 id="completedBookings" class="counter mt-2">0</h2>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="card text-center p-3">
                        <div class="text-muted">Pending Bookings</div>
                        <h2 id="pendingBookings" class="counter mt-2">0</h2>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="card text-center p-3">
                        <div class="text-muted">Online Drivers</div>
                        <h2 id="onlineDrivers" class="counter mt-2">0</h2>
                    </div>
                </div>

                <div class="col-lg-6 col-md-12 mt-4">
                    <div class="card text-center p-3">
                        <div class="text-muted">Total Revenue</div>
                        <h2 id="totalRevenue" class="counter mt-2">0</h2>
                    </div>
                </div>

            </div>

            <!-- Revenue Chart -->
            <div class="card mt-5 p-4">
                <h5 class="mb-3">Revenue Analytics</h5>
                <canvas id="revenueChart" height="100"></canvas>
            </div>

        </div>

    </section>

</div>

<!-- Animated Counter + Auto Refresh Script -->
<script>
function animateValue(element, start, end, duration = 800) {
    let startTime = null;

    function animation(currentTime) {
        if (!startTime) startTime = currentTime;
        const progress = currentTime - startTime;
        const percentage = Math.min(progress / duration, 1);
        const value = Math.floor(start + (end - start) * percentage);
        element.innerText = value.toLocaleString();
        if (progress < duration) {
            requestAnimationFrame(animation);
        } else {
            element.innerText = end.toLocaleString();
        }
    }

    requestAnimationFrame(animation);
}

function fetchKPIs() {
    fetch('api/kpi-stats.php')
        .then(response => response.json())
        .then(data => {

            Object.keys(data).forEach(key => {
                const el = document.getElementById(key);
                if (!el) return;

                const currentValue = parseFloat(el.innerText.replace(/,/g, '')) || 0;
                const newValue = parseFloat(data[key]);

                if (currentValue !== newValue) {
                    animateValue(el, currentValue, newValue);
                }
            });

        })
        .catch(error => console.error('KPI Fetch Error:', error));
}

// Initial load
fetchKPIs();

// Auto refresh every 20 seconds
setInterval(fetchKPIs, 20000);
</script>

<!-- Chart.js Revenue Chart -->
<script>
const ctx = document.getElementById('revenueChart').getContext('2d');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['Jan','Feb','Mar','Apr','May','Jun'],
        datasets: [{
            label: 'Revenue',
            data: [1200, 1900, 3000, 2500, 4000, 5200],
            borderColor: '#C9A24D',
            backgroundColor: 'rgba(201,162,77,0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        plugins: {
            legend: {
                labels: { color: '#E5E7EB' }
            }
        },
        scales: {
            x: {
                ticks: { color: '#9CA3AF' },
                grid: { color: 'rgba(255,255,255,0.05)' }
            },
            y: {
                ticks: { color: '#9CA3AF' },
                grid: { color: 'rgba(255,255,255,0.05)' }
            }
        }
    }
});
</script>

<?php include 'includes/footer.php'; ?>
