<?php require_once __DIR__ . '/includes/header.php'; ?>

<style>
/* ================================
   Ultra Executive Styling
================================ */
body {
    background-color: #0B0F19;
    color: #E5E7EB;
    font-family: 'Montserrat', sans-serif;
}

.section-padding {
    padding: 100px 0;
}

.gold-text {
    color: #C9A24D;
}

.btn-gold {
    background-color: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
    border: none;
    padding: 12px 28px;
    transition: all 0.3s ease;
}

.btn-gold:hover {
    background-color: #b8913f;
    color: #fff;
    transform: translateY(-2px);
}

.hero-section {
    height: 100vh;
    background: linear-gradient(rgba(11,15,25,0.85), rgba(11,15,25,0.85)),
        url('assets/img/hero-bg.jpg') center/cover no-repeat;
    display: flex;
    align-items: center;
}

.hero-title {
    font-family: 'Playfair Display', serif;
    font-size: 56px;
    font-weight: 700;
}

.price-card {
    background: rgba(31, 41, 55, 0.85);
    backdrop-filter: blur(12px);
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 0 40px rgba(0,0,0,0.5);
}

.service-card {
    background: #1F2937;
    border-radius: 10px;
    padding: 30px;
    transition: all 0.3s ease;
}

.service-card:hover {
    border: 1px solid #C9A24D;
    transform: translateY(-5px);
}
</style>

<!-- HERO SECTION -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            
            <div class="col-lg-6">
                <h1 class="hero-title mb-4">
                    Executive Mobility.<br>
                    <span class="gold-text">Elevated Experience.</span>
                </h1>
                <p class="mb-4 text-muted">
                    Premium airport transfers, chauffeur services, and executive concierge
                    coordination across Singapore.
                </p>
                <a href="#booking" class="btn btn-gold">Book Now</a>
            </div>

            <div class="col-lg-6">
                <div class="price-card">
                    <h4 class="mb-4 gold-text">Quick Price Estimate</h4>

                    <form id="priceForm">
                        <div class="form-group">
                            <label>Service Type</label>
                            <select class="form-control" id="service">
                                <option value="arrival">Airport Arrival ($65)</option>
                                <option value="departure">Airport Departure</option>
                                <option value="point">Point to Point ($65)</option>
                                <option value="city">City Tour ($120)</option>
                                <option value="limo">Limousine ($120)</option>
                                <option value="hourly">Hourly Booking</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Zone (Departure Only)</label>
                            <select class="form-control" id="zone">
                                <option value="0">Select Zone</option>
                                <option value="60">East ($60)</option>
                                <option value="70">North ($70)</option>
                                <option value="70">West ($70)</option>
                                <option value="70">Central ($70)</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Hours (For Hourly Service)</label>
                            <input type="number" id="hours" class="form-control" min="1" value="1">
                        </div>

                        <div class="mt-4">
                            <h5>Estimated Price:</h5>
                            <h2 class="gold-text" id="estimatedPrice">$65</h2>
                        </div>

                        <button type="button" class="btn btn-gold btn-block mt-3">
                            Proceed to Booking
                        </button>
                    </form>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- SERVICES -->
<section class="section-padding">
    <div class="container text-center">
        <h2 class="mb-5 gold-text">Our Premium Services</h2>

        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="service-card">
                    <h5>Airport Transfers</h5>
                    <p class="text-muted">Meet & greet and executive departures.</p>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="service-card">
                    <h5>City Tours</h5>
                    <p class="text-muted">Curated Singapore experiences.</p>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="service-card">
                    <h5>Limousine Service</h5>
                    <p class="text-muted">VIP events and corporate occasions.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- WHY US -->
<section class="section-padding" style="background:#1F2937;">
    <div class="container text-center">
        <h2 class="gold-text mb-4">Why Exclusive Concierge</h2>
        <p class="text-muted mb-5">
            Discretion. Precision. Executive-level service.
        </p>

        <div class="row">
            <div class="col-md-3">
                <h6 class="gold-text">Personalized Attention</h6>
            </div>
            <div class="col-md-3">
                <h6 class="gold-text">24/7 Availability</h6>
            </div>
            <div class="col-md-3">
                <h6 class="gold-text">Professional Chauffeurs</h6>
            </div>
            <div class="col-md-3">
                <h6 class="gold-text">Absolute Discretion</h6>
            </div>
        </div>
    </div>
</section>

<script>
/* ================================
   Simple Price Estimator Logic
================================ */
document.getElementById("priceForm").addEventListener("change", function() {

    let service = document.getElementById("service").value;
    let zone = parseInt(document.getElementById("zone").value);
    let hours = parseInt(document.getElementById("hours").value);
    let price = 0;

    switch(service) {
        case "arrival":
            price = 65;
            break;
        case "departure":
            price = zone > 0 ? zone : 0;
            break;
        case "point":
            price = 65;
            break;
        case "city":
            price = 120;
            break;
        case "limo":
            price = 120;
            break;
        case "hourly":
            price = 15 + (15 * hours);
            break;
    }

    document.getElementById("estimatedPrice").innerText = "$" + price;
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
