<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Exclusive Concierge | Executive Admin</title>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600&family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<!-- Bootstrap 4.6 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

<!-- AdminLTE 3.2 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">

<style>
:root {
    --primary: #0B0F19;
    --secondary: #1F2937;
    --accent: #C9A24D;
    --text: #E5E7EB;
    --muted: #9CA3AF;
}

/* Body Styling */
body {
    font-family: 'Montserrat', sans-serif;
    background: linear-gradient(135deg, #0B0F19, #1F2937);
    color: var(--text);
}

/* Navbar Executive Style */
.navbar-dark {
    background: rgba(15, 23, 42, 0.95) !important;
    backdrop-filter: blur(15px);
    border-bottom: 1px solid rgba(201,162,77,0.2);
}

/* Brand */
.navbar-brand {
    font-family: 'Playfair Display', serif;
    color: var(--accent) !important;
    font-size: 20px;
    letter-spacing: 1px;
}

/* Sidebar */
.main-sidebar {
    background: #0F172A !important;
    border-right: 1px solid rgba(201,162,77,0.2);
}

/* Sidebar links */
.nav-sidebar .nav-link {
    color: var(--text) !important;
    font-size: 14px;
}

.nav-sidebar .nav-link:hover {
    background: rgba(201,162,77,0.1) !important;
    color: var(--accent) !important;
}

.nav-sidebar .nav-link.active {
    background: rgba(201,162,77,0.15) !important;
    border-left: 3px solid var(--accent);
    color: var(--accent) !important;
}

/* Cards Executive Glass */
.card {
    background: rgba(31,41,55,0.6);
    backdrop-filter: blur(15px);
    border-radius: 16px;
    border: 1px solid rgba(201,162,77,0.2);
}

/* Footer */
.main-footer {
    background: rgba(15, 23, 42, 0.95);
    border-top: 1px solid rgba(201,162,77,0.2);
    color: var(--muted);
}

/* Buttons */
.btn-accent {
    background: var(--accent);
    color: #000;
    font-weight: 600;
}

.btn-accent:hover {
    background: #d8b868;
}

/* Content Wrapper */
.content-wrapper {
    background: transparent;
}
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="wrapper">

<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-dark">
    
    <!-- Sidebar toggle -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button">
                <i class="fas fa-bars"></i>
            </a>
        </li>
    </ul>

    <!-- Brand -->
    <a href="dashboard.php" class="navbar-brand ml-3">
        Exclusive Concierge
    </a>

    <!-- Right Navbar -->
    <ul class="navbar-nav ml-auto">

        <?php if(isset($_SESSION['admin_name'])): ?>

        <!-- User Dropdown -->
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                <i class="far fa-user"></i>
                <?= htmlspecialchars($_SESSION['admin_name']); ?>
            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <a href="profile.php" class="dropdown-item">
                    <i class="fas fa-user mr-2"></i> Profile
                </a>
                <a href="settings.php" class="dropdown-item">
                    <i class="fas fa-cog mr-2"></i> Settings
                </a>
                <div class="dropdown-divider"></div>
                <a href="logout.php" class="dropdown-item text-danger">
                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                </a>
            </div>
        </li>

        <?php endif; ?>

    </ul>

</nav>
