<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/translator.php';

// Load system settings
$stmt = $pdo->query("
SELECT setting_key, setting_value 
FROM system_settings 
WHERE setting_key IN (
'company_logo',
'company_phone',
'company_email',
'company_name'
)
");

$settings = [];
foreach ($stmt as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$logo = $settings['company_logo'] ?? '';
$companyName = $settings['company_name'] ?? 'Exclusive Concierge';
$companyPhone = $settings['company_phone'] ?? '';
$companyEmail = $settings['company_email'] ?? '';
?>

<!DOCTYPE html>
<html lang="<?= htmlspecialchars($GLOBALS['current_lang'] ?? 'en') ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= htmlspecialchars($companyName) ?> | Executive Transport Singapore</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/css/style.css">

<style>
body {
    font-family: 'Montserrat', sans-serif;
}

/* Top Bar */
.top-bar {
    background: #0B0F19;
    color: #9CA3AF;
    font-size: 13px;
    padding: 6px 0;
    border-bottom: 1px solid #1F2937;
}

.top-bar a {
    color: #C9A24D;
}

/* Navbar */
.navbar {
    background: rgba(11,15,25,0.92);
    backdrop-filter: blur(12px);
    transition: all 0.3s ease;
}

.navbar.scrolled {
    background: rgba(11,15,25,0.98);
    box-shadow: 0 5px 25px rgba(0,0,0,0.6);
}

.navbar-brand img {
    height: 45px;
}

.nav-link {
    color: #E5E7EB !important;
    font-weight: 500;
    margin-right: 18px;
    position: relative;
}

.nav-link:after {
    content: '';
    display: block;
    width: 0;
    height: 2px;
    background: #C9A24D;
    transition: width .3s;
}

.nav-link:hover:after {
    width: 100%;
}

.btn-gold {
    background: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
    border-radius: 30px;
    padding: 8px 22px;
    transition: all 0.3s ease;
}

.btn-gold:hover {
    background: #b88f3f;
    transform: translateY(-2px);
}

/* Language Dropdown */
.language-selector .dropdown-menu {
    background:#1F2937;
    border:1px solid #2c3645;
}

.language-selector .dropdown-item {
    color:#E5E7EB;
}

.language-selector .dropdown-item:hover {
    background:#0B0F19;
    color:#C9A24D;
}

.navbar-toggler {
    border-color:#C9A24D;
}
</style>

</head>
<body>

<!-- Top Contact Bar -->
<div class="top-bar">
<div class="container d-flex justify-content-between">

<div>
<?= htmlspecialchars($companyPhone) ?> |
<a href="mailto:<?= htmlspecialchars($companyEmail) ?>">
<?= htmlspecialchars($companyEmail) ?>
</a>
</div>

<div>
<?= __t('tagline') ?>
</div>

</div>
</div>

<nav class="navbar navbar-expand-lg navbar-dark fixed-top">
<div class="container">

<a class="navbar-brand d-flex align-items-center" href="index.php">

<?php if($logo): ?>
<img src="../admin/uploads/logo/<?= htmlspecialchars($logo) ?>" alt="Logo">
<?php else: ?>
<span style="color:#C9A24D;font-weight:600;">
<?= htmlspecialchars($companyName) ?>
</span>
<?php endif; ?>

</a>

<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#nav">
<span class="navbar-toggler-icon"></span>
</button>

<div class="collapse navbar-collapse" id="nav">
<ul class="navbar-nav ml-auto align-items-center">

<li class="nav-item">
<a class="nav-link" href="#services">
<?= __t('services') ?>
</a>
</li>

<li class="nav-item">
<a class="nav-link" href="#fleet">
<?= __t('fleet') ?>
</a>
</li>

<li class="nav-item">
<a class="nav-link" href="#concierge">
<?= __t('concierge') ?>
</a>
</li>

<li class="nav-item">
<a href="booking.php" class="btn btn-gold ml-lg-3">
<?= __t('book_now') ?>
</a>
</li>

<!-- Language Selector -->
<li class="nav-item dropdown language-selector ml-3">
<a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown">
🌐 <?= strtoupper($GLOBALS['current_lang'] ?? 'en') ?>
</a>
<div class="dropdown-menu dropdown-menu-right">
<a class="dropdown-item" href="?lang=en">🇬🇧 English</a>
<a class="dropdown-item" href="?lang=zh">🇨🇳 中文</a>
</div>
</li>

</ul>
</div>

</div>
</nav>

<script>
window.addEventListener("scroll", function() {
    const nav = document.querySelector(".navbar");
    nav.classList.toggle("scrolled", window.scrollY > 50);
});
</script>
