<?php
require_once __DIR__ . '/../app/db.php';

// Load system settings
$stmt = $pdo->query("
SELECT setting_key, setting_value 
FROM system_settings 
WHERE setting_key IN (
'company_logo',
'company_phone',
'company_email',
'company_name',
'company_address'
)
");

$settings = [];
foreach ($stmt as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$logo = $settings['company_logo'] ?? '';
$companyName = $settings['company_name'] ?? 'Exclusive Concierge';
$companyPhone = $settings['company_phone'] ?? '';
$companyEmail = $settings['company_email'] ?? '';
$companyAddress = $settings['company_address'] ?? '';
?>

<style>
.footer-main {
    background: #0B0F19;
    color: #9CA3AF;
    padding: 80px 0 40px;
}

.footer-main h5 {
    color: #C9A24D;
    font-weight: 600;
    margin-bottom: 20px;
}

.footer-main a {
    color: #9CA3AF;
    display: block;
    margin-bottom: 8px;
    transition: 0.3s;
}

.footer-main a:hover {
    color: #C9A24D;
    text-decoration: none;
}

.footer-logo img {
    max-height: 60px;
    margin-bottom: 20px;
}

.footer-newsletter input {
    background: #1F2937;
    border: 1px solid #2c3645;
    color: #E5E7EB;
}

.footer-newsletter button {
    background: #C9A24D;
    border: none;
    color: #0B0F19;
    font-weight: 600;
}

.footer-bottom {
    border-top: 1px solid #1F2937;
    padding-top: 20px;
    margin-top: 40px;
    font-size: 14px;
    text-align: center;
    color: #6c757d;
}
.payment-icon {
    height: 38px;
    margin: 0 15px;
    opacity: 0.7;
    transition: all 0.3s ease;
    filter: grayscale(100%);
}

.payment-icon:hover {
    opacity: 1;
    filter: grayscale(0%);
    transform: scale(1.05);
}

</style>

<footer class="footer-main">
<div class="container">

<div class="row">

<!-- Column 1: Brand -->
<div class="col-md-4">

<div class="footer-logo">
<?php if($logo): ?>
<img src="../admin/uploads/logo/<?= htmlspecialchars($logo) ?>">
<?php else: ?>
<h4 style="color:#C9A24D;">
<?= htmlspecialchars($companyName) ?>
</h4>
<?php endif; ?>
</div>

<p>
Premium executive airport transfers, chauffeur services,
and luxury ground transportation across Singapore.
</p>

<p>
📍 <?= htmlspecialchars($companyAddress) ?><br>
📞 <?= htmlspecialchars($companyPhone) ?><br>
✉ <?= htmlspecialchars($companyEmail) ?>
</p>

</div>

<!-- Column 2: Services -->
<div class="col-md-3">
<h5>Our Services</h5>

<a href="#">Airport Arrival</a>
<a href="#">Airport Departure</a>
<a href="#">Point to Point</a>
<a href="#">City Tour</a>
<a href="#">Limousine Service</a>
<a href="#">Hourly Booking</a>

</div>

<!-- Column 3: Quick Links -->
<div class="col-md-3">
<h5>Quick Links</h5>

<a href="index.php">Home</a>
<a href="#services">Services</a>
<a href="#fleet">Fleet</a>
<a href="#concierge">Concierge</a>
<a href="booking.php">Book Now</a>
<a href="#">Privacy Policy</a>

</div>

<!-- Column 4: Newsletter -->
<div class="col-md-2">
<h5>Newsletter</h5>

<p>Subscribe for exclusive updates.</p>

<div class="footer-newsletter">
<form>
<input type="email" class="form-control mb-2"
placeholder="Your Email">
<button type="button" class="btn btn-block">
Subscribe
</button>
</form>
</div>

</div>

</div>
<!-- Payment Methods -->
<div class="row mt-5">
<div class="col text-center">

<h6 style="color:#C9A24D; margin-bottom:20px;">
Secure Payment Options
</h6>

<div class="payment-icons d-flex justify-content-center align-items-center flex-wrap">

<img src="assets/images/payments/visa.svg" 
class="payment-icon" alt="Visa">

<img src="assets/images/payments/mastercard.svg" 
class="payment-icon" alt="Mastercard">

<img src="assets/images/payments/paynow.png" 
class="payment-icon" alt="PayNow">

</div>

</div>
</div>

<div class="footer-bottom">
© <?= date('Y') ?> <?= htmlspecialchars($companyName) ?>.
All Rights Reserved. | Premium Executive Chauffeur Singapore
</div>

</div>
</footer>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/app.js"></script>

<?php
// Format WhatsApp number (remove spaces & +)
$whatsappNumber = preg_replace('/[^0-9]/', '', $companyPhone);
?>

<style>
.whatsapp-float {
    position: fixed;
    bottom: 30px;
    right: 30px;
    z-index: 9999;
}

.whatsapp-btn {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg,#C9A24D,#b88f3f);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.5);
    transition: all 0.3s ease;
    position: relative;
}

.whatsapp-btn img {
    width: 28px;
    height: 28px;
}

.whatsapp-btn:hover {
    transform: scale(1.1);
    box-shadow: 0 12px 30px rgba(201,162,77,0.6);
}

/* Gold Pulse Animation */
.whatsapp-btn::after {
    content: '';
    position: absolute;
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: rgba(201,162,77,0.4);
    animation: pulse 2s infinite;
    z-index: -1;
}

@keyframes pulse {
    0% { transform: scale(1); opacity: 0.7; }
    70% { transform: scale(1.6); opacity: 0; }
    100% { opacity: 0; }
}

/* Tooltip */
.whatsapp-tooltip {
    position: absolute;
    right: 75px;
    background: #1F2937;
    color: #C9A24D;
    padding: 8px 14px;
    border-radius: 20px;
    font-size: 13px;
    white-space: nowrap;
    opacity: 0;
    transform: translateX(10px);
    transition: all 0.3s ease;
}

.whatsapp-float:hover .whatsapp-tooltip {
    opacity: 1;
    transform: translateX(0);
}
</style>

<div class="whatsapp-float">

<div class="whatsapp-tooltip">
24/7 Concierge
</div>

<a href="https://wa.me/<?= $whatsappNumber ?>?text=Hello%20Exclusive%20Concierge,%20I%20would%20like%20to%20make%20a%20booking."
target="_blank"
class="whatsapp-btn">

<img src="assets/images/payments/whatsapp-icon.svg" alt="WhatsApp">

</a>

</div>
<?php
$callNumber = preg_replace('/[^0-9+]/', '', $companyPhone);
?>

<style>
.phone-float {
    position: fixed;
    bottom: 105px; /* Above WhatsApp */
    right: 30px;
    z-index: 9999;
}

.phone-btn {
    width: 58px;
    height: 58px;
    background: linear-gradient(135deg,#C9A24D,#b88f3f);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.5);
    transition: all 0.3s ease;
    position: relative;
}

.phone-btn img {
    width: 26px;
    height: 26px;
}

.phone-btn:hover {
    transform: scale(1.1);
    box-shadow: 0 12px 30px rgba(201,162,77,0.6);
}

/* Elegant Pulse */
.phone-btn::after {
    content: '';
    position: absolute;
    width: 58px;
    height: 58px;
    border-radius: 50%;
    background: rgba(201,162,77,0.35);
    animation: phonePulse 2s infinite;
    z-index: -1;
}

@keyframes phonePulse {
    0% { transform: scale(1); opacity: 0.7; }
    70% { transform: scale(1.6); opacity: 0; }
    100% { opacity: 0; }
}

/* Tooltip */
.phone-tooltip {
    position: absolute;
    right: 75px;
    background: #1F2937;
    color: #C9A24D;
    padding: 8px 14px;
    border-radius: 20px;
    font-size: 13px;
    white-space: nowrap;
    opacity: 0;
    transform: translateX(10px);
    transition: all 0.3s ease;
}

.phone-float:hover .phone-tooltip {
    opacity: 1;
    transform: translateX(0);
}

/* Optional: Hide on desktop if desired */
/*
@media (min-width: 992px) {
    .phone-float {
        display: none;
    }
}
*/
</style>

<div class="phone-float">

<div class="phone-tooltip">
Call Now
</div>

<a href="tel:<?= htmlspecialchars($callNumber) ?>"
class="phone-btn">

<img src="assets/images/payments/phone-call-icon.svg" alt="Call">

</a>

</div>

</body>
</html>

