<?php
require_once '../../../app/db.php';
require_once '../../../app/jwt.php';

$data = json_decode(file_get_contents("php://input"), true);

$email = $data['email'] ?? '';
$password = $data['password'] ?? '';

$stmt = $pdo->prepare("SELECT * FROM drivers WHERE email=?");
$stmt->execute([$email]);
$driver = $stmt->fetch();

if (!$driver || !password_verify($password, $driver['password'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid credentials']);
    exit;
}

$token = generateJWT($driver['id']);

echo json_encode([
    'token' => $token,
    'driver' => [
        'id' => $driver['id'],
        'name' => $driver['full_name'],
        'status' => $driver['status']
    ]
]);
