<?php require 'includes/auth.php'; ?>
<?php require_once '../app/db.php'; ?>

<?php
$monthly = $pdo->query("
SELECT DATE_FORMAT(created_at,'%Y-%m') as month,
SUM(estimated_price) as revenue
FROM bookings
WHERE payment_status='paid'
GROUP BY month
");
?>

<h2>Monthly Revenue</h2>

<table class="table">
<tr>
<th>Month</th>
<th>Revenue</th>
</tr>

<?php foreach($monthly as $m): ?>
<tr>
<td><?= $m['month'] ?></td>
<td>$<?= number_format($m['revenue'],2) ?></td>
</tr>
<?php endforeach; ?>
</table>
