<?php 
require 'includes/auth.php'; 
require_once '../app/db.php'; 
?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>

<?php
$totalBookings = $pdo->query("SELECT COUNT(*) FROM bookings")->fetchColumn();
$totalDrivers  = $pdo->query("SELECT COUNT(*) FROM drivers")->fetchColumn();
$totalRevenue  = $pdo->query("
SELECT SUM(estimated_price)
FROM bookings WHERE payment_status='paid'
")->fetchColumn() ?? 0;

$pending = $pdo->query("
SELECT COUNT(*) FROM bookings WHERE status='pending'
")->fetchColumn();

$activeJobs = $pdo->query("
SELECT COUNT(*) FROM bookings 
WHERE status IN ('assigned','accepted','on_the_way','arrived')
")->fetchColumn();

$onlineDrivers = $pdo->query("
SELECT COUNT(*) FROM drivers WHERE status='online'
")->fetchColumn();

$recentBookings = $pdo->query("
SELECT b.booking_code, b.service_type, 
b.status, b.estimated_price, c.name
FROM bookings b
JOIN customers c ON b.customer_id=c.id
ORDER BY b.created_at DESC
LIMIT 5
");
?>

<style>
.content-wrapper {
    background: #0B0F19;
}

.kpi-card {
    background: linear-gradient(135deg,#1F2937,#0B0F19);
    border-left: 4px solid #C9A24D;
    color: #E5E7EB;
    border-radius: 8px;
    padding: 20px;
    transition: 0.3s;
}

.kpi-card:hover {
    transform: translateY(-4px);
}

.kpi-title {
    font-size: 14px;
    color: #9CA3AF;
}

.kpi-value {
    font-size: 26px;
    font-weight: 600;
    color: #C9A24D;
}

.table-dark-custom {
    background: #1F2937;
    color: #E5E7EB;
}

.section-title {
    color: #C9A24D;
    font-weight: 600;
    margin-bottom: 20px;
}
</style>

<div class="content-wrapper">
<section class="content pt-4">
<div class="container-fluid">

<h3 class="section-title">Executive Operations Dashboard</h3>

<div class="row">

<div class="col-lg-3 col-md-6">
<div class="kpi-card">
<div class="kpi-title">Total Bookings</div>
<div class="kpi-value"><?= $totalBookings ?></div>
</div>
</div>

<div class="col-lg-3 col-md-6">
<div class="kpi-card">
<div class="kpi-title">Total Revenue</div>
<div class="kpi-value">$<?= number_format($totalRevenue,2) ?></div>
</div>
</div>

<div class="col-lg-3 col-md-6">
<div class="kpi-card">
<div class="kpi-title">Active Jobs</div>
<div class="kpi-value"><?= $activeJobs ?></div>
</div>
</div>

<div class="col-lg-3 col-md-6">
<div class="kpi-card">
<div class="kpi-title">Online Drivers</div>
<div class="kpi-value"><?= $onlineDrivers ?></div>
</div>
</div>

</div>

<hr style="border-color:#1F2937;">

<div class="row mt-4">

<div class="col-lg-6">

<h5 class="section-title">Booking Overview</h5>

<div class="kpi-card mb-3">
<div class="kpi-title">Pending Dispatch</div>
<div class="kpi-value"><?= $pending ?></div>
</div>

<div class="kpi-card">
<div class="kpi-title">Active Assignments</div>
<div class="kpi-value"><?= $activeJobs ?></div>
</div>

</div>

<div class="col-lg-6">

<h5 class="section-title">Driver Summary</h5>

<div class="kpi-card mb-3">
<div class="kpi-title">Total Drivers</div>
<div class="kpi-value"><?= $totalDrivers ?></div>
</div>

<div class="kpi-card">
<div class="kpi-title">Online Now</div>
<div class="kpi-value"><?= $onlineDrivers ?></div>
</div>

</div>

</div>

<hr style="border-color:#1F2937;">

<div class="row mt-4">

<div class="col-lg-12">

<h5 class="section-title">Recent Bookings</h5>

<table class="table table-dark table-bordered table-dark-custom">
<thead>
<tr>
<th>Booking Code</th>
<th>Customer</th>
<th>Service</th>
<th>Status</th>
<th>Amount</th>
</tr>
</thead>
<tbody>
<?php foreach($recentBookings as $rb): ?>
<tr>
<td><?= $rb['booking_code'] ?></td>
<td><?= $rb['name'] ?></td>
<td><?= ucfirst($rb['service_type']) ?></td>
<td><?= ucfirst($rb['status']) ?></td>
<td>$<?= number_format($rb['estimated_price'],2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

</div>

</div>

</div>
</section>
</div>

<?php include 'includes/footer.php'; ?>
