<?php
$current = basename($_SERVER['PHP_SELF']);

function active($file, $current){
    return $file == $current ? 'active' : '';
}

$role = $_SESSION['admin_role'] ?? 'manager';
?>

<aside class="main-sidebar sidebar-dark-primary elevation-4">

<!-- BRAND -->
<a href="index.php" class="brand-link text-center">
    <span class="brand-text">Exclusive Concierge</span>
</a>

<div class="sidebar">

<!-- USER PANEL -->
<div class="user-panel mt-3 pb-3 mb-3 d-flex align-items-center">
    <div class="image">
        <i class="fas fa-user-circle fa-2x text-warning"></i>
    </div>
    <div class="info">
        <a href="#" class="d-block text-light">
            <?= $_SESSION['admin_name'] ?? 'Admin' ?>
        </a>
        <small class="text-muted text-uppercase">
            <?= $role ?>
        </small>
    </div>
</div>

<nav class="mt-2">
<ul class="nav nav-pills nav-sidebar flex-column"
data-widget="treeview" role="menu">

<!-- DASHBOARD -->
<li class="nav-item">
<a href="index.php"
class="nav-link <?= active('index.php',$current) ?>">
<i class="nav-icon fas fa-tachometer-alt"></i>
<p>Dashboard</p>
</a>
</li>

<!-- OPERATIONS HEADER -->
<li class="nav-header text-gold">OPERATIONS</li>

<li class="nav-item">
<a href="bookings.php"
class="nav-link <?= active('bookings.php',$current) ?>">
<i class="nav-icon fas fa-calendar-check"></i>
<p>Bookings</p>
</a>
</li>

<li class="nav-item">
<a href="dispatch.php"
class="nav-link <?= active('dispatch.php',$current) ?>">
<i class="nav-icon fas fa-car-side"></i>
<p>Dispatch Control</p>
</a>
</li>

<li class="nav-item">
<a href="driver_map.php"
class="nav-link <?= active('driver_map.php',$current) ?>">
<i class="nav-icon fas fa-map-marked-alt"></i>
<p>Live Driver Map</p>
</a>
</li>

<li class="nav-item">
<a href="drivers.php"
class="nav-link <?= active('drivers.php',$current) ?>">
<i class="nav-icon fas fa-id-badge"></i>
<p>Drivers</p>
</a>
</li>

<li class="nav-item">
<a href="vehicles.php"
class="nav-link <?= active('vehicles.php',$current) ?>">
<i class="nav-icon fas fa-car"></i>
<p>Fleet</p>
</a>
</li>

<li class="nav-item">
<a href="payments.php"
class="nav-link <?= active('payments.php',$current) ?>">
<i class="nav-icon fas fa-credit-card"></i>
<p>Payments</p>
</a>
</li>

<li class="nav-item">
<a href="reports.php"
class="nav-link <?= active('reports.php',$current) ?>">
<i class="nav-icon fas fa-chart-line"></i>
<p>Reports</p>
</a>
</li>

<!-- ADMIN SECTION (SUPERADMIN ONLY) -->
<?php if($role === 'superadmin'): ?>
<li class="nav-header text-gold">ADMINISTRATION</li>

<li class="nav-item">
<a href="admin_users.php"
class="nav-link <?= active('admin_users.php',$current) ?>">
<i class="nav-icon fas fa-users-cog"></i>
<p>Admin Users</p>
</a>
</li>

<li class="nav-item">
<a href="settings.php"
class="nav-link <?= active('settings.php',$current) ?>">
<i class="nav-icon fas fa-cogs"></i>
<p>System Settings</p>
</a>
</li>
<?php endif; ?>

<!-- LOGOUT -->
<li class="nav-header text-gold">ACCOUNT</li>

<li class="nav-item">
<a href="logout.php" class="nav-link text-danger">
<i class="nav-icon fas fa-sign-out-alt"></i>
<p>Logout</p>
</a>
</li>

</ul>
</nav>

</div>
</aside>

<style>

/* ===== SIDEBAR BASE ===== */
.sidebar-dark-primary {
    background-color: #1F2937 !important;
}

/* ===== BRAND SHIMMER ===== */
.brand-text {
    font-weight: 600;
    background: linear-gradient(
        90deg,
        #C9A24D 0%,
        #f4e2a1 50%,
        #C9A24D 100%
    );
    background-size: 200% auto;
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    animation: shimmer 4s linear infinite;
}

@keyframes shimmer {
    0% { background-position: 0% center; }
    100% { background-position: 200% center; }
}

/* ===== NAV LINKS ===== */
.nav-sidebar .nav-link {
    color: #9CA3AF;
    transition: 0.3s;
}

.nav-sidebar .nav-link:hover {
    background-color: #0B0F19;
    color: #C9A24D;
    box-shadow: inset 4px 0 0 #C9A24D;
}

.nav-sidebar .nav-link.active {
    background-color: #0B0F19;
    color: #C9A24D;
    box-shadow: inset 4px 0 0 #C9A24D;
}

/* ===== SECTION HEADER ===== */
.nav-header.text-gold {
    color: #C9A24D;
    font-weight: 600;
    letter-spacing: 1px;
    font-size: 11px;
}

/* ===== SMOOTH TRANSITION ===== */
.nav-sidebar .nav-link,
.brand-link {
    transition: all 0.3s ease;
}

</style>
