<?php require 'includes/auth.php'; ?>
<?php require_once '../app/db.php'; ?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>

<style>
.audit-card {
    background:#1F2937;
    border:1px solid #2c3645;
}

.gold-title {
    color:#C9A24D;
    font-weight:600;
}
</style>

<div class="content-wrapper">
<section class="content pt-4">
<div class="container-fluid">

<h3 class="gold-title mb-4">Audit Log Viewer</h3>

<div class="card audit-card">
<div class="card-body">

<table class="table table-dark table-striped">
<thead>
<tr>
<th>Date</th>
<th>Admin</th>
<th>Module</th>
<th>Action</th>
<th>Reference</th>
<th>IP Address</th>
</tr>
</thead>

<tbody>

<?php
$stmt = $pdo->query("
SELECT * FROM audit_logs
ORDER BY created_at DESC
LIMIT 500
");

foreach($stmt as $log):
?>

<tr>
<td><?= $log['created_at'] ?></td>
<td><?= $log['admin_name'] ?></td>
<td><?= $log['module'] ?></td>
<td><?= $log['action'] ?></td>
<td><?= $log['reference_id'] ?? '-' ?></td>
<td><?= $log['ip_address'] ?></td>
</tr>

<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

</div>
</section>
</div>

<?php include 'includes/footer.php'; ?>
