<?php
require_once __DIR__ . '/vendor/autoload.php';

use App\Core\Database;

$db = Database::connect();

$ref = $_POST['ref'] ?? $_GET['ref'] ?? null;

if (!$ref) die('Invalid booking.');

$stmt = $db->prepare("SELECT * FROM bookings WHERE booking_reference = ?");
$stmt->execute([$ref]);
$booking = $stmt->fetch();

if (!$booking) die('Invalid booking.');

$transaction_id = $_POST['transaction_reference'] ?? 'MANUAL_' . uniqid();

$db->beginTransaction();

$stmt = $db->prepare("
INSERT INTO payments
(booking_id, payment_method, payment_status, transaction_reference, paid_amount)
VALUES (?, 'manual', 'pending', ?, ?)
");
$stmt->execute([
$booking['id'],
$transaction_id,
$booking['final_price']
]);

$stmt = $db->prepare("
INSERT INTO booking_timeline
(booking_id, status, updated_by)
VALUES (?, 'manual payment submitted', 'customer')
");
$stmt->execute([$booking['id']]);

$db->commit();

header("Location: view_booking.php");
