<?php
session_start();
require_once __DIR__ . '/vendor/autoload.php';

use App\Core\Database;

$db = Database::connect();

$ref = $_GET['ref'] ?? '';

if (!$ref) die('Invalid reference.');

$stmt = $db->prepare("
    SELECT *
    FROM bookings
    WHERE booking_reference = ?
    AND status = 'accepted'
    LIMIT 1
");
$stmt->execute([$ref]);
$booking = $stmt->fetch();

if (!$booking) {
    die('Booking not eligible for payment.');
}
?>

<?php require_once __DIR__ . '/includes/book_header.php'; ?>

<section class="section-padding">
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-8">

<div class="booking-card p-5">

<h4 class="gold-text mb-4">Complete Payment</h4>

<p><strong>Booking Ref:</strong> <?php echo $booking['booking_reference']; ?></p>
<p><strong>Total:</strong>
<span class="gold-text">
$<?php echo number_format($booking['final_price'],2); ?>
</span>
</p>

<hr>

<h5>Select Payment Method</h5>

<div class="mt-4">

<!-- STRIPE -->
<a href="process_payment_stripe.php?ref=<?php echo $booking['booking_reference']; ?>"
class="btn btn-gold btn-block mb-3">
Pay by Credit / Debit Card
</a>

<!-- PAYNOW QR -->
<a href="process_payment_paynow.php?ref=<?php echo $booking['booking_reference']; ?>"
class="btn btn-outline-light btn-block mb-3">
PayNow QR
</a>

<!-- MANUAL TRANSFER -->
<a href="process_payment_manual.php?ref=<?php echo $booking['booking_reference']; ?>"
class="btn btn-secondary btn-block">
Bank Transfer
</a>

</div>

</div>
</div>
</div>
</div>
</section>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
