<?php
declare(strict_types=1);

/*
|--------------------------------------------------------------------------
| APPLICATION ENVIRONMENT
|--------------------------------------------------------------------------
*/

define('APP_ENV', $_ENV['APP_ENV'] ?? 'production');
define('APP_DEBUG', APP_ENV === 'local');

/*
|--------------------------------------------------------------------------
| BASE URL
|--------------------------------------------------------------------------
*/

define('APP_URL', $_ENV['APP_URL'] ?? 'https://exclconcierge.cpforce.com.sg');

/*
|--------------------------------------------------------------------------
| DATABASE CONFIG
|--------------------------------------------------------------------------
*/

define('DB_HOST', $_ENV['DB_HOST'] ?? 'localhost');
define('DB_NAME', $_ENV['DB_NAME'] ?? 'dc2025_excl_transport');
define('DB_USER', $_ENV['DB_USER'] ?? 'dc2025_admin');
define('DB_PASS', $_ENV['DB_PASS'] ?? 'M1963@noor123');

/*
|--------------------------------------------------------------------------
| SECURITY
|--------------------------------------------------------------------------
*/

define('APP_KEY', $_ENV['APP_KEY'] ?? bin2hex(random_bytes(32)));
define('JWT_SECRET', $_ENV['JWT_SECRET'] ?? hash('sha256', APP_KEY));

/*
|--------------------------------------------------------------------------
| TIMEZONE
|--------------------------------------------------------------------------
*/

date_default_timezone_set('Asia/Singapore');

/*
|--------------------------------------------------------------------------
| ERROR HANDLING
|--------------------------------------------------------------------------
*/

if (APP_DEBUG) {
    ini_set('display_errors', '1');
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', '0');
}
