<?php
/*
|--------------------------------------------------------------------------
| Admin Authentication Middleware
|--------------------------------------------------------------------------
|
| Protects all admin routes.
| - Requires valid session
| - Validates role
| - Enforces session timeout
| - Prevents session hijacking
|
*/

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/*
|--------------------------------------------------------------------------
| CONFIG
|--------------------------------------------------------------------------
*/
$SESSION_TIMEOUT = 60 * 60; // 1 hour

/*
|--------------------------------------------------------------------------
| NOT LOGGED IN
|--------------------------------------------------------------------------
*/
if (empty($_SESSION['admin_id']) || empty($_SESSION['admin_role'])) {
    header("Location: /admin/login.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| ROLE VALIDATION
|--------------------------------------------------------------------------
*/
if ($_SESSION['admin_role'] !== 'admin') {
    session_destroy();
    header("Location: /admin/login.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| SESSION TIMEOUT
|--------------------------------------------------------------------------
*/
if (isset($_SESSION['last_activity'])) {

    if ((time() - $_SESSION['last_activity']) > $SESSION_TIMEOUT) {

        session_unset();
        session_destroy();

        header("Location: /admin/login.php?timeout=1");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| UPDATE ACTIVITY TIME
|--------------------------------------------------------------------------
*/
$_SESSION['last_activity'] = time();

/*
|--------------------------------------------------------------------------
| OPTIONAL: IP CHECK (Anti Hijacking)
|--------------------------------------------------------------------------
*/
if (!isset($_SESSION['ip_address'])) {
    $_SESSION['ip_address'] = $_SERVER['REMOTE_ADDR'];
} else {
    if ($_SESSION['ip_address'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: /admin/login.php");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| OPTIONAL: USER AGENT CHECK
|--------------------------------------------------------------------------
*/
if (!isset($_SESSION['user_agent'])) {
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
} else {
    if ($_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT']) {
        session_unset();
        session_destroy();
        header("Location: /admin/login.php");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| Secure Headers (Admin Area Only)
|--------------------------------------------------------------------------
*/
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("Referrer-Policy: strict-origin");
header("X-XSS-Protection: 1; mode=block");
